/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.wildfly.common.codec.DecodeException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store._private.ElytronMessages;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.util.AtomicFileOutputStream;

public class PropertiesCredentialStore
extends CredentialStoreSpi {
    private static final Pattern PATTERN = Pattern.compile("^\\s*(#.*)|(\\w+=[^=]+={0,2}\\s*)$");
    public static final String NAME = PropertiesCredentialStore.class.getSimpleName();
    private final String HEADER = "# Properties Credential Store (Do Not Modify)";
    private static final char COMMENT = '#';
    private static final char DELIMITER = '=';
    private static final String CREATE = "create";
    private static final String LOCATION = "location";
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AtomicReference<Map<String, SecretKey>> entries = new AtomicReference();
    private volatile File credentialStoreLocation;

    @Override
    public void initialize(Map<String, String> attributes, CredentialStore.ProtectionParameter protectionParameter, Provider[] providers) throws CredentialStoreException {
        try (Lock lock = this.lockForWrite();){
            String location = attributes.get(LOCATION);
            if (location == null) {
                throw ElytronMessages.log.missingInitialisationAttribute(LOCATION);
            }
            boolean create = Boolean.parseBoolean(attributes.getOrDefault(CREATE, Boolean.FALSE.toString()));
            File credentialStoreLocation = new File(location);
            boolean exists = credentialStoreLocation.exists();
            if (!create && !exists) {
                throw ElytronMessages.log.automaticStorageCreationDisabled(location);
            }
            this.credentialStoreLocation = credentialStoreLocation;
            if (exists) {
                this.entries.set(this.load());
            } else {
                this.entries.set(new LinkedHashMap());
                this.save();
            }
            this.initialized = true;
        }
        catch (IOException e) {
            throw ElytronMessages.log.cannotInitializeCredentialStore(e);
        }
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public void store(String credentialAlias, Credential credential, CredentialStore.ProtectionParameter protectionParameter) throws CredentialStoreException, UnsupportedCredentialTypeException {
        Class<?> credentialClass = credential.getClass();
        if (credentialClass == SecretKeyCredential.class) {
            try (Lock lock = this.lockForWrite();){
                this.assertInitialised();
                this.entries.get().put(credentialAlias.toLowerCase(Locale.getDefault()), ((SecretKeyCredential)credential).getSecretKey());
            }
        } else {
            throw ElytronMessages.log.unsupportedCredentialType(credentialClass);
        }
    }

    @Override
    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec, CredentialStore.ProtectionParameter protectionParameter) throws CredentialStoreException {
        block8: {
            if (credentialType.isAssignableFrom(SecretKeyCredential.class)) {
                try (Lock lock = this.lockForRead();){
                    this.assertInitialised();
                    SecretKey secretKey = this.entries.get().get(credentialAlias.toLowerCase(Locale.getDefault()));
                    if (secretKey != null) {
                        SecretKeyCredential credential = new SecretKeyCredential(secretKey);
                        Credential credential2 = (Credential)credentialType.cast(credential);
                        return (C)credential2;
                    }
                    break block8;
                }
            }
            throw ElytronMessages.log.unsupportedCredentialType(credentialType);
        }
        return null;
    }

    @Override
    public void remove(String credentialAlias, Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) throws CredentialStoreException {
        if (credentialType.isAssignableFrom(SecretKeyCredential.class)) {
            try (Lock lock = this.lockForWrite();){
                this.assertInitialised();
                this.entries.get().remove(credentialAlias.toLowerCase(Locale.getDefault()));
            }
        } else {
            throw ElytronMessages.log.unsupportedCredentialType(credentialType);
        }
    }

    @Override
    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        try (Lock lock = this.lockForRead();){
            this.assertInitialised();
            HashSet<String> hashSet = new HashSet<String>(this.entries.get().keySet());
            return hashSet;
        }
    }

    @Override
    public void flush() throws CredentialStoreException {
        try (Lock lock = this.lockForWrite();){
            this.assertInitialised();
            this.save();
        }
    }

    private void save() throws CredentialStoreException {
        try (PrintWriter pw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new AtomicFileOutputStream(this.credentialStoreLocation))), false);){
            pw.println("# Properties Credential Store (Do Not Modify)");
            for (Map.Entry<String, SecretKey> entry : this.entries.get().entrySet()) {
                pw.print(entry.getKey());
                pw.print('=');
                pw.println(SecretKeyUtil.exportSecretKey((SecretKey)entry.getValue()));
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw ElytronMessages.log.cannotFlushCredentialStore(e);
        }
    }

    private Map<String, SecretKey> load() throws CredentialStoreException, IOException {
        LinkedHashMap<String, SecretKey> entries = new LinkedHashMap<String, SecretKey>();
        try (FileReader fr = new FileReader(this.credentialStoreLocation);
             BufferedReader bis = new BufferedReader(fr);){
            String line;
            Predicate<String> validLine = PATTERN.asPredicate();
            block12: while ((line = bis.readLine()) != null) {
                int i;
                if (!validLine.test(line)) {
                    throw ElytronMessages.log.invalidCredentialStoreProperty(line);
                }
                char[] currentLine = line.toCharArray();
                int start = -1;
                int delimiter = -1;
                int end = -1;
                for (i = 0; i < currentLine.length && delimiter < 0; ++i) {
                    if (start < 0) {
                        if (currentLine[i] == '#') continue block12;
                        if (!Character.isWhitespace(currentLine[i])) {
                            start = i;
                        }
                    }
                    if (currentLine[i] != '=') continue;
                    delimiter = i;
                }
                if (delimiter > 0) {
                    for (i = currentLine.length - 1; i > delimiter && end < 0; --i) {
                        if (Character.isWhitespace(currentLine[i])) continue;
                        end = i;
                    }
                }
                if (start > -1 && delimiter > -1 && end > -1) {
                    SecretKey secretKey;
                    String alias = new String(currentLine, start, delimiter - start).toLowerCase(Locale.getDefault());
                    try {
                        secretKey = SecretKeyUtil.importSecretKey((char[])currentLine, (int)(delimiter + 1), (int)(end - delimiter));
                    }
                    catch (GeneralSecurityException | DecodeException e) {
                        throw ElytronMessages.log.canNotLoadSecretKey(alias, e);
                    }
                    entries.put(alias, secretKey);
                    continue;
                }
                throw ElytronMessages.log.invalidCredentialStoreProperty(line);
            }
        }
        return entries;
    }

    private void assertInitialised() throws CredentialStoreException {
        if (!this.initialized) {
            throw ElytronMessages.log.storeNotInitialised();
        }
    }

    private Lock lockForRead() {
        this.readWriteLock.readLock().lock();
        return () -> this.readWriteLock.readLock().unlock();
    }

    private Lock lockForWrite() {
        this.readWriteLock.writeLock().lock();
        return () -> this.readWriteLock.writeLock().unlock();
    }

    static interface Lock
    extends AutoCloseable {
        @Override
        public void close();
    }
}

