/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.netty.server;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

class ElytronResponse {
    private final List<Header> headers = new ArrayList<Header>();
    private volatile ByteArrayOutputStream outputStream;
    private volatile int statusCode;

    ElytronResponse() {
    }

    void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    void addHeader(String name, String value) {
        this.headers.add(new Header(name, value));
    }

    OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }

    byte[] getResponseBytes() {
        if (this.outputStream != null) {
            return this.outputStream.toByteArray();
        }
        return null;
    }

    List<Header> getHeaders() {
        return this.headers;
    }

    static class Header {
        private final String name;
        private final String value;

        Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }
    }
}

