/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.netty.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.wildfly.elytron.web.netty.server.ElytronHttpExchange;
import org.wildfly.elytron.web.netty.server.ElytronResponse;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

class ElytronInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final AsciiString CONTENT_LENGTH = AsciiString.cached((String)"Content-Length");
    private final HttpAuthenticationFactory httpAuthenticationFactory;
    private final SecurityDomain securityDomain;
    private final Predicate<HttpRequest> authenticationRequired;
    private volatile ElytronResponse elytronResponse;
    private volatile SecurityIdentity securityIdentity;

    ElytronInboundHandler(HttpAuthenticationFactory httpAuthenticationFactory, Predicate<HttpRequest> authenticationRequired) {
        this.httpAuthenticationFactory = httpAuthenticationFactory;
        this.securityDomain = httpAuthenticationFactory.getSecurityDomain();
        this.authenticationRequired = authenticationRequired;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        System.out.println("ElytronInboundHandler.channelRead()");
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            boolean authenticationRequired = this.authenticationRequired != null ? this.authenticationRequired.test(httpRequest) : true;
            this.elytronResponse = new ElytronResponse();
            ElytronHttpExchange elytronExchange = new ElytronHttpExchange(httpRequest, this.elytronResponse, ctx.channel().remoteAddress());
            HttpAuthenticator authenticator = HttpAuthenticator.builder().setSecurityDomain(this.securityDomain).setMechanismSupplier(() -> this.httpAuthenticationFactory.getMechanismNames().stream().map(mechanismName -> {
                try {
                    return (HttpServerAuthenticationMechanism)this.httpAuthenticationFactory.createMechanism(mechanismName);
                }
                catch (HttpAuthenticationException e) {
                    throw new RuntimeException("Failed to create mechanism.", e);
                }
            }).filter(m -> m != null).collect(Collectors.toList())).setHttpExchangeSpi((HttpExchangeSpi)elytronExchange).setRequired(authenticationRequired).build();
            boolean authenticated = authenticator.authenticate();
            if (!authenticated) {
                System.out.println("ElytronInboundHandler - Lets turn this request around.");
                byte[] responseBody = this.elytronResponse.getResponseBytes();
                HttpResponseStatus responseStatus = this.elytronResponse.getStatusCode() > 0 ? HttpResponseStatus.valueOf((int)this.elytronResponse.getStatusCode()) : HttpResponseStatus.OK;
                DefaultFullHttpResponse response = responseBody != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.wrappedBuffer((byte[])responseBody)) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus);
                response.headers().setInt((CharSequence)CONTENT_LENGTH, response.content().readableBytes());
                ctx.write((Object)response);
                return;
            }
            this.securityIdentity = elytronExchange.getSecurityIdentity();
        }
        super.channelRead(ctx, msg);
    }

    SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    ElytronResponse getElytronResponse() {
        return this.elytronResponse;
    }
}

