/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.KeyPairCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.X509CertificateChainPrivateCredential;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.Scope;

public class ElytronHttpExchange
implements HttpExchangeSpi {
    private final Request request;
    private final Response response;

    public ElytronHttpExchange(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public List<String> getRequestHeaderValues(String headerName) {
        Enumeration headerEnum = this.request.getHeaders(headerName);
        if (headerEnum == null) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList();
        while (headerEnum.hasMoreElements()) {
            values.add(headerEnum.nextElement());
        }
        return Collections.unmodifiableList(values);
    }

    public void addResponseHeader(String headerName, String headerValue) {
        this.response.addHeader(headerName, headerValue);
    }

    public void setStatusCode(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
        Subject subject = new Subject();
        Principal principal = securityIdentity.getPrincipal();
        subject.getPrincipals().add(principal);
        ElytronHttpExchange.addPrivateCredentials(subject, securityIdentity);
        Roles roles = securityIdentity.getRoles();
        ArrayList rolesList = new ArrayList();
        roles.spliterator().forEachRemaining(role -> {
            rolesList.add(role);
            subject.getPrincipals().add((Principal)new AbstractLoginService.RolePrincipal(role));
        });
        this.request.setAuthentication((Authentication)new ElytronUserAuthentication(this.request.getAuthType(), (UserIdentity)new DefaultUserIdentity(subject, principal, rolesList.toArray(new String[rolesList.size()])), securityIdentity));
    }

    public void authenticationFailed(String message, String mechanismName) {
    }

    public void badRequest(HttpAuthenticationException error, String mechanismName) {
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public URI getRequestURI() {
        try {
            return this.request.getHttpURI().toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getRequestPath() {
        return this.request.getHttpURI().getPath();
    }

    public Map<String, List<String>> getRequestParameters() {
        Map requestParameters = this.request.getParameterMap();
        if (requestParameters == null) {
            return null;
        }
        HashMap<String, List<String>> convertedRequestParameters = new HashMap<String, List<String>>(requestParameters.size());
        for (String parameter : requestParameters.keySet()) {
            convertedRequestParameters.put(parameter, Arrays.asList((Object[])requestParameters.get(parameter)));
        }
        return convertedRequestParameters;
    }

    public List<HttpServerCookie> getCookies() {
        List<HttpServerCookie> cookies = Stream.of(this.request.getCookies()).map(new Function<Cookie, HttpServerCookie>(){

            @Override
            public HttpServerCookie apply(final Cookie cookie) {
                return new HttpServerCookie(){

                    public String getName() {
                        return cookie.getName();
                    }

                    public String getValue() {
                        return cookie.getValue();
                    }

                    public String getDomain() {
                        return cookie.getDomain();
                    }

                    public int getMaxAge() {
                        return cookie.getMaxAge();
                    }

                    public String getPath() {
                        return cookie.getPath();
                    }

                    public boolean isSecure() {
                        return cookie.getSecure();
                    }

                    public int getVersion() {
                        return cookie.getVersion();
                    }

                    public boolean isHttpOnly() {
                        return cookie.isHttpOnly();
                    }
                };
            }
        }).collect(Collectors.toList());
        return cookies;
    }

    public InputStream getRequestInputStream() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public OutputStream getResponseOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InetSocketAddress getSourceAddress() {
        return this.request.getRemoteInetSocketAddress();
    }

    public void setResponseCookie(HttpServerCookie cookie) {
        this.response.addCookie(new HttpCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), (long)cookie.getMaxAge(), cookie.isHttpOnly(), cookie.isSecure(), null, cookie.getVersion()));
    }

    public HttpScope getScope(Scope scope) {
        return null;
    }

    public Collection<String> getScopeIds(Scope scope) {
        return null;
    }

    public HttpScope getScope(Scope scope, String id) {
        return null;
    }

    private static void addPrivateCredentials(Subject subject, SecurityIdentity securityIdentity) {
        for (Credential credential : securityIdentity.getPrivateCredentials()) {
            if (credential instanceof PasswordCredential) {
                ElytronHttpExchange.addPrivateCredential(subject, ((PasswordCredential)credential.castAs(PasswordCredential.class)).getPassword());
                continue;
            }
            if (credential instanceof SecretKeyCredential) {
                ElytronHttpExchange.addPrivateCredential(subject, ((SecretKeyCredential)credential.castAs(SecretKeyCredential.class)).getSecretKey());
                continue;
            }
            if (credential instanceof KeyPairCredential) {
                ElytronHttpExchange.addPrivateCredential(subject, ((KeyPairCredential)credential.castAs(KeyPairCredential.class)).getKeyPair());
                continue;
            }
            if (credential instanceof X509CertificateChainPrivateCredential) {
                ElytronHttpExchange.addPrivateCredential(subject, ((X509CertificateChainPrivateCredential)credential.castAs(X509CertificateChainPrivateCredential.class)).getCertificateChain());
                continue;
            }
            ElytronHttpExchange.addPrivateCredential(subject, credential);
        }
    }

    private static void addPrivateCredential(Subject subject, Object credential) {
        subject.getPrivateCredentials().add(credential);
    }

    class ElytronUserAuthentication
    extends UserAuthentication {
        private final SecurityIdentity securityIdentity;

        public ElytronUserAuthentication(String method, UserIdentity userIdentity, SecurityIdentity securityIdentity) {
            super(method, userIdentity);
            this.securityIdentity = securityIdentity;
        }

        public SecurityIdentity getSecurityIdentity() {
            return this.securityIdentity;
        }
    }
}

