/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.File;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.tools.server.DomainConfiguration;
import org.wildfly.plugin.tools.server.StandaloneConfiguration;

public abstract class Configuration<T extends Configuration<T>> {
    private final CommandBuilder commandBuilder;
    private final Map<String, String> env;
    private boolean redirectErrorStream;
    private ProcessBuilder.Redirect outputDestination;
    private ProcessBuilder.Redirect errorDestination;
    private File workingDirectory;
    private ModelControllerClient client;
    private String managementAddress;
    private int managementPort;
    private boolean shutdownOnClose;

    protected Configuration(CommandBuilder commandBuilder) {
        this.commandBuilder = commandBuilder;
        this.env = new LinkedHashMap<String, String>();
    }

    public static StandaloneConfiguration create(StandaloneCommandBuilder commandBuilder) {
        return new StandaloneConfiguration((CommandBuilder)commandBuilder);
    }

    public static StandaloneConfiguration create(BootableJarCommandBuilder commandBuilder) {
        return new StandaloneConfiguration((CommandBuilder)commandBuilder);
    }

    public static DomainConfiguration create(DomainCommandBuilder commandBuilder) {
        return new DomainConfiguration((CommandBuilder)commandBuilder);
    }

    public T client(ModelControllerClient client) {
        this.client = client;
        return this.self();
    }

    protected ModelControllerClient client() {
        if (this.client == null) {
            try {
                return ModelControllerClient.Factory.create((String)this.managementAddress(), (int)this.managementPort());
            }
            catch (UnknownHostException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.client;
    }

    public T managementAddress(String managementAddress) {
        this.managementAddress = managementAddress;
        return this.self();
    }

    protected String managementAddress() {
        return this.managementAddress == null ? "127.0.0.1" : this.managementAddress;
    }

    public T managementPort(int managementPort) {
        this.managementPort = managementPort;
        return this.self();
    }

    protected int managementPort() {
        return this.managementPort > 0 ? this.managementPort : 9990;
    }

    public T shutdownOnClose(boolean shutdownOnClose) {
        this.shutdownOnClose = shutdownOnClose;
        return this.self();
    }

    protected boolean shutdownOnClose() {
        return this.shutdownOnClose;
    }

    public T redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this.self();
    }

    public T redirectOutput(File file) {
        this.outputDestination = ProcessBuilder.Redirect.to(file);
        return this.self();
    }

    public T redirectOutput(Path path) {
        return this.redirectOutput(path.toFile());
    }

    public T redirectOutput(ProcessBuilder.Redirect destination) {
        this.outputDestination = destination;
        return this.self();
    }

    protected boolean consumeStdout() {
        return this.outputDestination == ProcessBuilder.Redirect.PIPE || this.outputDestination == null;
    }

    public T redirectError(File file) {
        this.errorDestination = ProcessBuilder.Redirect.to(file);
        return this.self();
    }

    public T redirectError(ProcessBuilder.Redirect destination) {
        this.errorDestination = destination;
        return this.self();
    }

    protected boolean consumeStderr() {
        return !this.redirectErrorStream && (this.errorDestination == ProcessBuilder.Redirect.PIPE || this.errorDestination == null);
    }

    public T directory(Path path) {
        this.workingDirectory = path == null ? null : path.toAbsolutePath().normalize().toFile();
        return this.self();
    }

    public T directory(File dir) {
        this.workingDirectory = dir;
        return this.self();
    }

    public T directory(String dir) {
        if (dir == null) {
            return this.self();
        }
        Path path = Path.of(dir, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Directory '%s' does not exist", dir));
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Directory '%s' is not a directory.", dir));
        }
        return this.directory(path.toAbsolutePath().normalize());
    }

    public T addEnvironmentVariable(String key, String value) {
        if (key != null && value != null) {
            this.env.put(key, value);
        }
        return this.self();
    }

    public T addEnvironmentVariables(Map<String, String> env) {
        env.forEach((key, value) -> {
            if (key != null && value != null) {
                this.addEnvironmentVariable((String)key, (String)value);
            }
        });
        return this.self();
    }

    protected CommandBuilder commandBuilder() {
        return this.commandBuilder;
    }

    protected Launcher launcher() {
        return Launcher.of((CommandBuilder)this.commandBuilder).addEnvironmentVariables(this.env).redirectError(this.errorDestination).redirectOutput(this.outputDestination).setDirectory(this.workingDirectory).setRedirectErrorStream(this.redirectErrorStream);
    }

    protected abstract LaunchType launchType();

    protected abstract T self();

    protected static enum LaunchType {
        DOMAIN,
        STANDALONE;

    }
}

