/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.server;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.OperationExecutionException;
import org.wildfly.plugin.tools.server.AbstractServerManager;
import org.wildfly.plugin.tools.server.CommonOperations;

public class StandaloneManager
extends AbstractServerManager {
    private static final Logger LOGGER = Logger.getLogger(StandaloneManager.class);
    private final ModelControllerClient client;

    protected StandaloneManager(ProcessHandle process, ModelControllerClient client) {
        super(process, client);
        this.client = client;
    }

    @Override
    public ModelControllerClient client() {
        return this.client;
    }

    @Override
    public String serverState() {
        try {
            ModelNode response = this.client().execute(Operations.createReadAttributeOperation((ModelNode)CommonOperations.EMPTY_ADDRESS, (String)"server-state"));
            return Operations.isSuccessfulOutcome((ModelNode)response) ? Operations.readResult((ModelNode)response).asString() : "failed";
        }
        catch (IOException | RuntimeException e) {
            LOGGER.tracef("Interrupted determining the server state", (Object)e);
            return "failed";
        }
    }

    @Override
    public void executeReload() throws IOException {
        this.executeReload(Operations.createOperation((String)"reload"));
    }

    @Override
    public void reloadIfRequired() throws IOException {
        this.reloadIfRequired(10L, TimeUnit.SECONDS);
    }

    @Override
    public void reloadIfRequired(long timeout, TimeUnit unit) throws IOException {
        String launchType = this.launchType();
        if ("STANDALONE".equalsIgnoreCase(launchType)) {
            String runningState = this.serverState();
            if ("reload-required".equalsIgnoreCase(runningState)) {
                this.executeReload();
                try {
                    if (!this.waitFor(timeout, unit)) {
                        throw new RuntimeException(String.format("Failed to reload server within %d %s.", timeout, unit.name().toLowerCase(Locale.ROOT)));
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to reload the server.", e);
                }
            }
        } else {
            LOGGER.warnf("Cannot reload and wait for the server to start with a server type of %s.", (Object)launchType);
        }
    }

    @Override
    public boolean isRunning() {
        return CommonOperations.isStandaloneRunning(this.client);
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown(0L);
    }

    @Override
    public void shutdown(long timeout) throws IOException {
        ModelNode op = Operations.createOperation((String)"shutdown");
        op.get("timeout").set(timeout);
        ModelNode response = this.client.execute(op);
        if (Operations.isSuccessfulOutcome((ModelNode)response)) {
            while (this.isRunning()) {
                Thread.onSpinWait();
            }
        } else {
            throw new OperationExecutionException(op, response);
        }
    }
}

