/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.common.StandardOutput;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.server.ServerContext;
import org.wildfly.plugin.server.ServerType;
import org.wildfly.plugin.tools.server.ServerManager;

public abstract class AbstractStartMojo
extends AbstractServerConnection {
    @Inject
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    protected List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    protected String[] javaOpts;
    @Parameter(alias="java-home", property="java.home")
    protected String javaHome;
    @Parameter(property="wildfly.debug", defaultValue="false")
    protected boolean debug;
    @Parameter(property="wildfly.debug.host", defaultValue="*")
    protected String debugHost;
    @Parameter(property="wildfly.debug.port", defaultValue="8787")
    protected int debugPort;
    @Parameter(property="wildfly.debug.suspend", defaultValue="false")
    protected boolean debugSuspend;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    protected String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    @Parameter(alias="server-args", property="wildfly.serverArgs")
    protected String[] serverArgs;
    @Parameter(defaultValue="false", property="wildfly.skip")
    protected boolean skip;
    @Parameter
    private Map<String, String> env;
    private final AtomicBoolean initialized = new AtomicBoolean();
    protected ServerManager serverManager;
    protected MavenRepoManager mavenRepoManager;

    protected void init() throws MojoExecutionException {
        if (this.initialized.compareAndSet(false, true)) {
            MavenRepositoriesEnricher.enrich((MavenSession)this.mavenSession, (MavenProject)this.project, this.repositories);
            this.mavenRepoManager = this.createMavenRepoManager();
        }
    }

    protected MavenRepoManager createMavenRepoManager() throws MojoExecutionException {
        return new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
    }

    protected abstract Path getServerHome() throws MojoExecutionException, MojoFailureException;

    protected ServerContext startServer(ServerType serverType) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        this.init();
        final Path server = this.getServerHome();
        try {
            StandardOutput out = this.standardOutput();
            ModelControllerClient client = this.createClient();
            if (ServerManager.isRunning((ModelControllerClient)client)) {
                throw new MojoExecutionException(String.format("%s server is already running?", new Object[]{serverType}));
            }
            final CommandBuilder commandBuilder = this.createCommandBuilder(server);
            log.info((CharSequence)String.format("%s server is starting up.", new Object[]{serverType}));
            Launcher launcher = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true);
            if (this.env != null) {
                for (Map.Entry<String, String> entry : this.env.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    launcher.addEnvironmentVariable(entry.getKey(), entry.getValue());
                }
            }
            out.getRedirect().ifPresent(arg_0 -> ((Launcher)launcher).redirectOutput(arg_0));
            final Process process = launcher.launch();
            this.serverManager = serverType == ServerType.DOMAIN ? ServerManager.builder().process(process).client(client).domain() : ServerManager.builder().process(process).client(client).standalone();
            out.startConsumer(process);
            if (!this.serverManager.waitFor(this.startupTimeout, TimeUnit.SECONDS)) {
                throw new MojoExecutionException(String.format("Server failed to start in %s seconds.", this.startupTimeout));
            }
            if (!process.isAlive()) {
                throw new MojoExecutionException("The process has been terminated before the start goal has completed.");
            }
            return new ServerContext(){
                final /* synthetic */ AbstractStartMojo this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Process process() {
                    return process;
                }

                @Override
                public CommandBuilder commandBuilder() {
                    return commandBuilder;
                }

                @Override
                public Path jbossHome() {
                    return server;
                }
            };
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
    }

    protected abstract CommandBuilder createCommandBuilder(Path var1) throws MojoExecutionException;

    protected StandardOutput standardOutput() throws IOException {
        return StandardOutput.parse(null, false);
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    protected ServerContext actOnServerState(ModelControllerClient client, ServerContext context) throws IOException, MojoExecutionException, MojoFailureException {
        block6: {
            String serverState = this.serverManager.serverState();
            if ("restart-required".equals(serverState)) {
                this.serverManager.shutdown((long)this.timeout);
                return this.startServer(ServerType.STANDALONE);
            }
            if ("reload-required".equals(serverState)) {
                this.serverManager.executeReload(Operations.createOperation((String)"reload"));
                try {
                    if (!this.serverManager.waitFor(this.startupTimeout, TimeUnit.SECONDS)) {
                        throw new MojoExecutionException(String.format("Server failed to start in %s seconds.", this.startupTimeout));
                    }
                    break block6;
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Failed to wait for standalone server after a reload.", (Exception)e);
                }
            }
            if (!"running".equals(serverState)) {
                this.getLog().warn((CharSequence)String.format("The server may be in an unexpected state for further interaction. The current state is %s", serverState));
            }
        }
        return context;
    }

    @Override
    protected int getManagementPort() {
        if (this.javaOpts != null) {
            for (String opt : this.javaOpts) {
                if (opt.startsWith("-Djboss.management.http.port=") || opt.startsWith("-Djboss.management.https.port=")) {
                    int equals = opt.indexOf(61);
                    return Integer.parseInt(opt.substring(equals + 1).trim());
                }
                if (!opt.startsWith("-Djboss.socket.binding.port-offset=")) continue;
                int equals = opt.indexOf(61);
                return super.getManagementPort() + Integer.parseInt(opt.substring(equals + 1).trim());
            }
        }
        return super.getManagementPort();
    }

    @Override
    protected String getManagementHostName() {
        if (this.javaOpts != null) {
            for (String opt : this.javaOpts) {
                if (!opt.startsWith("-Djboss.bind.address.management=")) continue;
                int equals = opt.indexOf(61);
                return opt.substring(equals + 1).trim();
            }
        }
        return super.getManagementHostName();
    }
}

