/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.core.launcher.DomainCommandBuilder;
import org.wildfly.core.launcher.StandaloneCommandBuilder;
import org.wildfly.plugin.common.Environment;
import org.wildfly.plugin.common.Utils;
import org.wildfly.plugin.server.AbstractStartMojo;
import org.wildfly.plugin.server.AddUser;
import org.wildfly.plugin.server.ModulesPath;
import org.wildfly.plugin.tools.GalleonUtils;
import org.wildfly.plugin.tools.server.ServerManager;

public abstract class AbstractServerStartMojo
extends AbstractStartMojo {
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File targetDir;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    protected String jbossHome;
    @Parameter(alias="feature-pack-location", property="wildfly.feature-pack.location")
    private String featurePackLocation;
    @Parameter(property="wildfly.version")
    private String version;
    @Parameter(alias="provisioning-dir", property="wildfly.provisioning.dir", defaultValue="server")
    private String provisioningDir;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Parameter(alias="module-options", property="wildfly.moduleOptions")
    protected String[] moduleOptions;
    @Parameter(alias="add-user", property="wildfly.add-user")
    private AddUser addUser;

    @Override
    protected Path getServerHome() throws MojoExecutionException, MojoFailureException {
        Path jbossHome = this.provisionIfRequired(this.targetDir.toPath().resolve(this.provisioningDir));
        if (!ServerManager.isValidHomeDirectory((Path)jbossHome)) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", jbossHome));
        }
        return jbossHome;
    }

    public void setModulesOptions(String value) {
        if (value != null) {
            this.moduleOptions = value.split("\\s+");
        }
    }

    protected StandaloneCommandBuilder createStandaloneCommandBuilder(Path jbossHome, String serverConfig) throws MojoExecutionException {
        Path javaHomePath;
        StandaloneCommandBuilder commandBuilder = (StandaloneCommandBuilder)StandaloneCommandBuilder.of((Path)jbossHome).setJavaHome(this.javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setJavaOptions(this.javaOpts);
        }
        if (this.debug) {
            commandBuilder.addJavaOptions(new String[]{String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=%s,address=%s:%d", this.debugSuspend ? "y" : "n", this.debugHost, this.debugPort)});
        }
        if (serverConfig != null) {
            commandBuilder.setServerConfiguration(serverConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        if (Utils.isNotNullOrEmpty(this.moduleOptions)) {
            commandBuilder.setModuleOptions(this.moduleOptions);
        }
        Path path = javaHomePath = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        if (Environment.isModularJvm(javaHomePath)) {
            commandBuilder.addJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + String.valueOf(commandBuilder.getJavaHome())));
        log.info((CharSequence)("JBOSS_HOME: " + String.valueOf(commandBuilder.getWildFlyHome())));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getJavaOptions(), " ")));
        try {
            this.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add users", (Exception)e);
        }
        return commandBuilder;
    }

    protected DomainCommandBuilder createDomainCommandBuilder(Path jbossHome, String domainConfig, String hostConfig) throws MojoExecutionException {
        Path javaHome = this.javaHome == null ? Paths.get(System.getProperty("java.home"), new String[0]) : Paths.get(this.javaHome, new String[0]);
        DomainCommandBuilder commandBuilder = (DomainCommandBuilder)DomainCommandBuilder.of((Path)jbossHome, (Path)javaHome).addModuleDirs(this.modulesPath.getModulePaths());
        if (Utils.isNotNullOrEmpty(this.javaOpts)) {
            commandBuilder.setProcessControllerJavaOptions(this.javaOpts).setHostControllerJavaOptions(this.javaOpts);
        }
        if (domainConfig != null) {
            commandBuilder.setDomainConfiguration(domainConfig);
        }
        if (hostConfig != null) {
            commandBuilder.setHostConfiguration(hostConfig);
        }
        if (this.propertiesFile != null) {
            commandBuilder.setPropertiesFile(this.propertiesFile);
        }
        if (this.serverArgs != null) {
            commandBuilder.addServerArguments(this.serverArgs);
        }
        if (Environment.isModularJvm(javaHome)) {
            commandBuilder.addHostControllerJavaOptions(Environment.getModularJvmArguments());
            commandBuilder.addProcessControllerJavaOptions(Environment.getModularJvmArguments());
        }
        Log log = this.getLog();
        log.info((CharSequence)("JAVA_HOME : " + String.valueOf(commandBuilder.getJavaHome())));
        log.info((CharSequence)("JBOSS_HOME: " + String.valueOf(commandBuilder.getWildFlyHome())));
        log.info((CharSequence)("JAVA_OPTS : " + Utils.toString(commandBuilder.getHostControllerJavaOptions(), " ")));
        try {
            this.addUsers(commandBuilder.getWildFlyHome(), commandBuilder.getJavaHome());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to add users", (Exception)e);
        }
        return commandBuilder;
    }

    protected Path provisionIfRequired(Path installDir) throws MojoFailureException, MojoExecutionException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        try {
            if (!Files.exists(installDir, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Provisioning default server in " + String.valueOf(installDir)));
                GalleonUtils.provision((Path)installDir, (String)this.resolveFeaturePackLocation(), (String)this.version, (MavenRepoManager)this.mavenRepoManager);
            }
            return installDir;
        }
        catch (ProvisioningException ex) {
            throw new MojoFailureException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    private void addUsers(Path wildflyHome, Path javaHome) throws IOException {
        if (this.addUser != null && this.addUser.hasUsers()) {
            this.getLog().info((CharSequence)("Adding users: " + String.valueOf(this.addUser)));
            this.addUser.addUsers(wildflyHome, javaHome);
        }
    }

    private String resolveFeaturePackLocation() {
        return this.featurePackLocation == null ? this.getDefaultFeaturePackLocation() : this.featurePackLocation;
    }

    protected String getDefaultFeaturePackLocation() {
        return "wildfly@maven(org.jboss.universe:community-universe)";
    }
}

