/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.plugins.bootablejar.maven.common.FeaturePack;
import org.wildfly.plugins.bootablejar.maven.common.OverriddenArtifact;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;
import org.wildfly.plugins.bootablejar.maven.goals.MavenProjectArtifactVersions;
import org.wildfly.plugins.bootablejar.maven.goals.ScannedModules;

final class MavenUpgrade {
    private final Map<String, FeaturePack> dependencies = new LinkedHashMap<String, FeaturePack>();
    private final Map<String, FeaturePack> topLevels = new LinkedHashMap<String, FeaturePack>();
    private final AbstractBuildBootableJarMojo mojo;
    private final ProvisioningConfig config;
    private final Map<FeaturePackLocation.ProducerSpec, String> producerToGAC = new HashMap<FeaturePackLocation.ProducerSpec, String>();
    private final ProvisioningManager pm;
    private ScannedModules modules;

    MavenUpgrade(AbstractBuildBootableJarMojo mojo, ProvisioningConfig config, ProvisioningManager pm) throws MavenUniverseException, ProvisioningException, MojoExecutionException {
        this.mojo = mojo;
        this.config = config;
        this.pm = pm;
        for (FeaturePackConfig cfg : config.getFeaturePackDeps()) {
            FeaturePack featurePack = this.toFeaturePack(cfg, pm);
            if (featurePack == null) {
                throw new ProvisioningException("Invalid location " + cfg.getLocation());
            }
            this.topLevels.put(featurePack.getGAC(), featurePack);
        }
        LinkedHashMap<String, Path> resolvedFeaturePacks = new LinkedHashMap<String, Path>();
        for (FeaturePack featurePack : this.topLevels.values()) {
            resolvedFeaturePacks.put(featurePack.getGAC(), mojo.resolveMaven(featurePack));
        }
        mojo.debug("Top level feature-packs: %s", this.topLevels);
        mojo.debug("Resolved feature-packs: %s", resolvedFeaturePacks);
        for (Map.Entry entry : resolvedFeaturePacks.entrySet()) {
            FeaturePackSpec spec = FeaturePackDescriber.readSpec((Path)((Path)entry.getValue()));
            this.producerToGAC.put(spec.getFPID().getProducer(), (String)entry.getKey());
            ArrayList<FeaturePackConfig> allDeps = new ArrayList<FeaturePackConfig>();
            for (FeaturePackConfig cfg : spec.getFeaturePackDeps()) {
                allDeps.add(cfg);
            }
            for (FeaturePackConfig cfg : spec.getTransitiveDeps()) {
                allDeps.add(cfg);
            }
            for (FeaturePackConfig cfg : allDeps) {
                String gac;
                FeaturePack fp = this.toFeaturePack(cfg, pm);
                if (fp == null || this.topLevels.containsKey(gac = fp.getGAC()) || this.dependencies.containsKey(gac)) continue;
                Path p = mojo.resolveMaven(fp);
                FeaturePackSpec depSpec = FeaturePackDescriber.readSpec((Path)p);
                this.producerToGAC.put(depSpec.getFPID().getProducer(), gac);
                this.dependencies.put(gac, fp);
            }
        }
        mojo.debug("FP dependencies %s", this.dependencies);
    }

    private Map<String, String> getOriginalVersions() throws ProvisioningException, MojoExecutionException {
        return this.getScannedModules().getProvisionedArtifacts();
    }

    private ScannedModules getScannedModules() throws ProvisioningException, MojoExecutionException {
        if (this.modules == null) {
            this.modules = ScannedModules.scanProvisionedArtifacts(this.pm, this.config);
        }
        return this.modules;
    }

    void dumpArtifacts(Path file) throws ProvisioningException, MojoExecutionException, IOException {
        Map<String, Map<String, String>> perModules = this.getScannedModules().getPerModuleArtifacts();
        StringBuilder builder = new StringBuilder();
        builder.append("<all-artifacts>").append(System.lineSeparator());
        builder.append("  <galleon-feature-pack-dependencies>").append(System.lineSeparator());
        for (FeaturePack fp : this.dependencies.values()) {
            builder.append("    <feature-pack-dependency>").append(System.lineSeparator());
            builder.append("      <groupId>").append(fp.getGroupId()).append("</groupId>").append(System.lineSeparator());
            builder.append("      <artifactId>").append(fp.getArtifactId()).append("</artifactId>").append(System.lineSeparator());
            if (fp.getClassifier() != null && !fp.getClassifier().isEmpty()) {
                builder.append("      <classifier>").append(fp.getClassifier()).append("</classifier>").append(System.lineSeparator());
            }
            builder.append("      <version>").append(fp.getVersion()).append("</version>").append(System.lineSeparator());
            builder.append("      <type>").append(fp.getType()).append("</type>").append(System.lineSeparator());
            builder.append("    </feature-pack-dependency>").append(System.lineSeparator());
        }
        builder.append("  </galleon-feature-pack-dependencies>").append(System.lineSeparator());
        builder.append("  <jboss-modules-runtime>").append(System.lineSeparator());
        Artifact jbossModules = AbstractBuildBootableJarMojo.getArtifact(this.getScannedModules().getModuleRuntime());
        builder.append("    <groupId>").append(jbossModules.getGroupId()).append("</groupId>").append(System.lineSeparator());
        builder.append("    <artifactId>").append(jbossModules.getArtifactId()).append("</artifactId>").append(System.lineSeparator());
        if (jbossModules.getClassifier() != null && !jbossModules.getClassifier().isEmpty()) {
            builder.append("    <classifier>").append(jbossModules.getClassifier()).append("</classifier>").append(System.lineSeparator());
        }
        builder.append("    <version>").append(jbossModules.getVersion()).append("</version>").append(System.lineSeparator());
        builder.append("    <type>").append(jbossModules.getType()).append("</type>").append(System.lineSeparator());
        builder.append("  </jboss-modules-runtime>").append(System.lineSeparator());
        if (!this.getScannedModules().getCopiedArtifacts().isEmpty()) {
            builder.append("  <copied-artifacts>").append(System.lineSeparator());
            for (String string : this.getScannedModules().getCopiedArtifacts().values()) {
                Artifact a = AbstractBuildBootableJarMojo.getArtifact(string);
                builder.append("    <artifact>").append(System.lineSeparator());
                builder.append("      <groupId>").append(a.getGroupId()).append("</groupId>").append(System.lineSeparator());
                builder.append("      <artifactId>").append(a.getArtifactId()).append("</artifactId>").append(System.lineSeparator());
                if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
                    builder.append("      <classifier>").append(a.getClassifier()).append("</classifier>").append(System.lineSeparator());
                }
                builder.append("      <version>").append(a.getVersion()).append("</version>").append(System.lineSeparator());
                builder.append("      <type>").append(a.getType()).append("</type>").append(System.lineSeparator());
                builder.append("    </artifact>").append(System.lineSeparator());
            }
            builder.append("  </copied-artifacts>").append(System.lineSeparator());
        }
        builder.append("  <modules>").append(System.lineSeparator());
        for (Map.Entry entry : perModules.entrySet()) {
            builder.append("    <module name=\"").append((String)entry.getKey()).append("\">").append(System.lineSeparator());
            for (String s : ((Map)entry.getValue()).values()) {
                Artifact a = AbstractBuildBootableJarMojo.getArtifact(s);
                builder.append("      <artifact>").append(System.lineSeparator());
                builder.append("        <groupId>").append(a.getGroupId()).append("</groupId>").append(System.lineSeparator());
                builder.append("        <artifactId>").append(a.getArtifactId()).append("</artifactId>").append(System.lineSeparator());
                if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
                    builder.append("        <classifier>").append(a.getClassifier()).append("</classifier>").append(System.lineSeparator());
                }
                builder.append("        <version>").append(a.getVersion()).append("</version>").append(System.lineSeparator());
                builder.append("        <type>").append(a.getType()).append("</type>").append(System.lineSeparator());
                builder.append("      </artifact>").append(System.lineSeparator());
            }
            builder.append("    </module>").append(System.lineSeparator());
        }
        builder.append("  </modules>").append(System.lineSeparator());
        builder.append("</all-artifacts>").append(System.lineSeparator());
        Files.write(file, builder.toString().getBytes("UTF-8"), new OpenOption[0]);
    }

    private static String getOriginalArtifactVersion(OverriddenArtifact a, Map<String, String> originalArtifactVersions) {
        String key;
        String value;
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(a.getGroupId()).append(":").append(a.getArtifactId());
        if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
            keyBuilder.append("::").append(a.getClassifier());
        }
        if ((value = originalArtifactVersions.get(key = keyBuilder.toString())) == null) {
            return null;
        }
        Artifact artifact = AbstractBuildBootableJarMojo.getArtifact(value);
        return artifact.getVersion();
    }

    ProvisioningConfig upgrade() throws MojoExecutionException, ProvisioningDescriptionException, ProvisioningException {
        if (this.mojo.overriddenServerArtifacts.isEmpty()) {
            return this.config;
        }
        Map<String, String> originalVersions = this.getOriginalVersions();
        ArrayList<FeaturePack> featurePackDependencies = new ArrayList<FeaturePack>();
        ArrayList<OverriddenArtifact> artifactDependencies = new ArrayList<OverriddenArtifact>();
        HashMap<String, OverriddenArtifact> allArtifacts = new HashMap<String, OverriddenArtifact>();
        for (OverriddenArtifact overriddenArtifact : this.mojo.overriddenServerArtifacts) {
            String originalVersion;
            DefaultArtifactVersion overriddenVersion;
            DefaultArtifactVersion orig;
            int compared;
            if (overriddenArtifact.getGroupId() == null || overriddenArtifact.getArtifactId() == null) {
                throw new MojoExecutionException("Invalid overridden artifact " + overriddenArtifact.getGAC() + ". GroupId and ArtifactId are required.");
            }
            String key = overriddenArtifact.getGAC();
            if (allArtifacts.containsKey(key)) {
                throw new MojoExecutionException("Artifact " + key + " is present more than once in the overridden artifacts. Must be unique.");
            }
            allArtifacts.put(key, overriddenArtifact);
            if (this.dependencies.containsKey(key)) {
                FeaturePack dep;
                Artifact fpArtifact = this.mojo.artifactVersions.getFeaturePackArtifact(overriddenArtifact.getGroupId(), overriddenArtifact.getArtifactId(), overriddenArtifact.getClassifier());
                if (fpArtifact == null) {
                    throw new MojoExecutionException("No version for Galleon feature-pack " + overriddenArtifact.getGAC());
                }
                this.checkScope(fpArtifact);
                if (overriddenArtifact.getVersion() != null) {
                    fpArtifact.setVersion(overriddenArtifact.getVersion());
                }
                if ((compared = (orig = new DefaultArtifactVersion((dep = this.dependencies.get(key)).getVersion())).compareTo((ArtifactVersion)(overriddenVersion = new DefaultArtifactVersion(fpArtifact.getVersion())))) > 0) {
                    if (!this.mojo.disableWarnForArtifactDowngrade) {
                        this.mojo.getLog().warn((CharSequence)("[UPDATE] Downgrading dependency " + key + " from " + dep.getVersion() + " to " + fpArtifact.getVersion()));
                    }
                } else if (compared == 0) {
                    this.mojo.getLog().warn((CharSequence)("[UPDATE] Dependency " + key + " will be not upgraded, already at version: " + fpArtifact.getVersion()));
                }
                if (compared == 0) continue;
                FeaturePack fp = new FeaturePack();
                fp.setGroupId(overriddenArtifact.getGroupId());
                fp.setArtifactId(overriddenArtifact.getArtifactId());
                fp.setClassifier(fpArtifact.getClassifier());
                fp.setExtension(fpArtifact.getType());
                fp.setVersion(fpArtifact.getVersion());
                featurePackDependencies.add(fp);
                continue;
            }
            Artifact mavenArtifact = this.mojo.artifactVersions.getArtifact(overriddenArtifact);
            if (mavenArtifact == null) {
                Artifact fpArtifact = this.mojo.artifactVersions.getFeaturePackArtifact(overriddenArtifact.getGroupId(), overriddenArtifact.getArtifactId(), overriddenArtifact.getClassifier());
                if (fpArtifact != null) {
                    throw new MojoExecutionException("Zip artifact " + overriddenArtifact.getGAC() + " not found in dependencies.  Could be a wrong Galleon feature-pack used to override a feature-pack dependency.");
                }
                throw new MojoExecutionException("No version for artifact " + overriddenArtifact.getGAC());
            }
            this.checkScope(mavenArtifact);
            if (overriddenArtifact.getVersion() == null) {
                overriddenArtifact.setVersion(mavenArtifact.getVersion());
            }
            if (overriddenArtifact.getType() == null) {
                overriddenArtifact.setType(mavenArtifact.getType());
            }
            if ((originalVersion = MavenUpgrade.getOriginalArtifactVersion(overriddenArtifact, originalVersions)) == null) {
                throw new MojoExecutionException("Overridden artifact " + overriddenArtifact.getGAC() + " not know in provisioned feature-packs");
            }
            orig = new DefaultArtifactVersion(originalVersion);
            overriddenVersion = new DefaultArtifactVersion(overriddenArtifact.getVersion());
            compared = orig.compareTo((ArtifactVersion)overriddenVersion);
            if (compared > 0) {
                if (!this.mojo.disableWarnForArtifactDowngrade) {
                    this.mojo.getLog().warn((CharSequence)("[UPDATE] Downgrading artifact " + overriddenArtifact.getGAC() + " from " + originalVersion + " to " + overriddenArtifact.getVersion()));
                }
            } else if (compared == 0) {
                this.mojo.getLog().warn((CharSequence)("[UPDATE] Artifact " + overriddenArtifact.getGAC() + " is already at version " + overriddenArtifact.getVersion() + ", will be not upgraded."));
            }
            if (compared == 0) continue;
            artifactDependencies.add(overriddenArtifact);
        }
        if (!artifactDependencies.isEmpty() || !featurePackDependencies.isEmpty()) {
            ProvisioningConfig.Builder c = ProvisioningConfig.builder((ProvisioningConfig)this.config);
            if (!featurePackDependencies.isEmpty()) {
                this.mojo.getLog().info((CharSequence)"[UPDATE] Overriding Galleon feature-pack dependency with: ");
                for (FeaturePack fp : featurePackDependencies) {
                    FeaturePackLocation fpl = FeaturePackLocation.fromString((String)fp.getMavenCoords());
                    this.mojo.getLog().info((CharSequence)("[UPDATE]  " + fp.getGroupId() + ":" + fp.getArtifactId() + ":" + (String)(fp.getClassifier() == null ? "" : fp.getClassifier() + ":") + fp.getVersion() + (String)(fp.getExtension() == null ? "" : ":" + fp.getExtension())));
                    c.addTransitiveDep(fpl);
                }
            }
            if (!artifactDependencies.isEmpty()) {
                this.mojo.getLog().info((CharSequence)"[UPDATE] Overriding server artifacts with:");
                if (!this.mojo.pluginOptions.containsKey("jboss-overridden-artifacts")) {
                    String string = MavenUpgrade.toOptionValue(artifactDependencies);
                    for (OverriddenArtifact update : artifactDependencies) {
                        this.mojo.getLog().info((CharSequence)("[UPDATE]  " + update.getGroupId() + ":" + update.getArtifactId() + ":" + (String)(update.getClassifier() == null ? "" : update.getClassifier() + ":") + update.getVersion() + (String)(update.getType() == null ? "" : ":" + update.getType())));
                    }
                    c.addOption("jboss-overridden-artifacts", string);
                }
            }
            return c.build();
        }
        return this.config;
    }

    void checkScope(Artifact a) {
        if (!"provided".equals(a.getScope())) {
            this.mojo.getLog().warn((CharSequence)("[UPDATE] Overridden artifact " + a.getGroupId() + ":" + a.getArtifactId() + (String)(a.getClassifier() == null ? "" : ":" + a.getClassifier()) + ":" + a.getVersion() + " is not of provided scope."));
        }
    }

    static String locationWithVersion(String featurePackLocation, MavenProjectArtifactVersions artifactVersions) throws MojoExecutionException {
        FeaturePack fp;
        FeaturePackLocation location = FeaturePackLocation.fromString((String)featurePackLocation);
        if ((location.getUniverse() == null || location.getUniverse().getLocation() == null) && (fp = MavenUpgrade.getFeaturePack(featurePackLocation)).getVersion() == null) {
            Artifact fpArtifact = artifactVersions.getFeaturePackArtifact(fp.getGroupId(), fp.getArtifactId(), null);
            if (fpArtifact == null) {
                throw new MojoExecutionException("No version found for " + featurePackLocation);
            }
            fp.setVersion(fpArtifact.getVersion());
            featurePackLocation = fp.getMavenCoords();
        }
        return featurePackLocation;
    }

    private FeaturePack toFeaturePack(FeaturePackConfig cfg, ProvisioningManager pm) throws MojoExecutionException {
        MavenUpgrade.validateFPL(cfg.getLocation());
        FeaturePack fp = cfg.getLocation().isMavenCoordinates() ? MavenUpgrade.getFeaturePack(cfg.getLocation().toString()) : this.getFeaturePack(cfg, pm);
        return fp;
    }

    private static void validateFPL(FeaturePackLocation fpl) throws MojoExecutionException {
        if (fpl.getUniverse() == null || fpl.getProducer() == null) {
            throw new MojoExecutionException("Invalid feature-pack location format: " + fpl);
        }
    }

    String getMavenFeaturePack(FeaturePackLocation.FPID location) {
        String gac = this.producerToGAC.get(location.getProducer());
        if (gac == null) {
            return location.toString();
        }
        return gac + ":" + location.getBuild();
    }

    private FeaturePack getFeaturePack(FeaturePackConfig cfg, ProvisioningManager pm) {
        try {
            Channel channel = pm.getLayoutFactory().getUniverseResolver().getChannel(cfg.getLocation());
            if (channel instanceof MavenChannel) {
                MavenChannel mavenChannel = (MavenChannel)channel;
                FeaturePack fp = new FeaturePack();
                fp.setGroupId(mavenChannel.getFeaturePackGroupId());
                fp.setArtifactId(mavenChannel.getFeaturePackArtifactId());
                String build = cfg.getLocation().getBuild();
                if (build == null) {
                    build = mavenChannel.getLatestBuild(cfg.getLocation());
                }
                fp.setVersion(build);
                return fp;
            }
        }
        catch (ProvisioningException ex) {
            this.mojo.debug("Invalid channel for %s, the feature-pack is not known in the universe, skipping it.", cfg.getLocation());
        }
        return null;
    }

    static FeaturePack getFeaturePack(String str) throws MojoExecutionException {
        if (str == null) {
            throw new MojoExecutionException("Null feature-pack coords");
        }
        String[] parts = str.split(":");
        if (parts.length < 2 || parts.length > 5) {
            throw new MojoExecutionException("Invalid feature-pack location format: " + str);
        }
        FeaturePack fp = new FeaturePack();
        fp.setGroupId(parts[0]);
        fp.setArtifactId(parts[1]);
        String version = null;
        if (parts.length >= 4) {
            String classifier = parts[2] == null || parts[2].isEmpty() ? null : parts[2];
            String extension = parts[3] == null || parts[3].isEmpty() ? null : parts[3];
            fp.setClassifier(classifier);
            if (extension != null) {
                fp.setExtension(extension);
            }
            if (parts.length == 5) {
                version = parts[4] == null || parts[4].isEmpty() ? null : parts[4];
            }
        } else if (parts.length == 3) {
            version = parts[2];
        }
        fp.setVersion(version);
        return fp;
    }

    static String toOptionValue(List<OverriddenArtifact> lst) throws ProvisioningException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < lst.size(); ++i) {
            OverriddenArtifact artifact = lst.get(i);
            MavenUpgrade.validate(artifact);
            builder.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getVersion()).append(":");
            String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
            builder.append(classifier).append(":").append(artifact.getType());
            if (i >= lst.size() - 1) continue;
            builder.append("|");
        }
        return builder.toString();
    }

    private static void validate(OverriddenArtifact artifact) throws ProvisioningException {
        if (artifact.getGroupId() == null) {
            throw new ProvisioningException("No groupId set for overridden artifact");
        }
        if (artifact.getArtifactId() == null) {
            throw new ProvisioningException("No artifactId set for overridden artifact");
        }
        if (artifact.getVersion() == null) {
            throw new ProvisioningException("No version set for overridden artifact");
        }
        if (artifact.getType() == null) {
            throw new ProvisioningException("No type set for overridden artifact");
        }
    }
}

