/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;
import org.wildfly.plugins.bootablejar.maven.goals.StartBootableJarMojo;

@Mojo(name="dev", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public final class DevBootableJarMojo
extends AbstractBuildBootableJarMojo {
    private static final String DEPLOYMENT_SCANNER_LAYER = "deployment-scanner";
    public static final String DEPLOYMENT_SCANNER_NAME = "wildfly-jar-for-dev-mode";

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        if (Files.exists(this.getProvisioningFile(), new LinkOption[0]) && !this.hasLayers()) {
            this.getLog().warn((CharSequence)"Dev mode, can't enforce provisioning of deployment-scanner. Make sure your provisioned configuration contains deployment-scanner subsystem for dev mode to properly operate.");
        } else {
            if (this.getExcludedLayers().contains(DEPLOYMENT_SCANNER_LAYER)) {
                this.getLog().warn((CharSequence)"Dev mode, removing layer deployment-scanner from the list of excluded layers to ensure dev mode can be operated");
                this.getExcludedLayers().remove(DEPLOYMENT_SCANNER_LAYER);
            }
            this.getLog().info((CharSequence)"Dev mode, adding layer deployment-scanner to ensure dev mode can be operated");
            this.addExtraLayer(DEPLOYMENT_SCANNER_LAYER);
        }
        this.hollowJar = true;
        super.execute();
        new StartBootableJarMojo().startDevMode(this.project);
    }

    @Override
    protected void configureCli(List<String> commands) {
        this.configureScanner(this.getDeploymentsDir(), commands);
    }

    private void configureScanner(Path deployments, List<String> commands) {
        commands.add("/subsystem=deployment-scanner/scanner=wildfly-jar-for-dev-mode:add(scan-interval=1000,auto-deploy-exploded=false,path=\"" + deployments + "\")");
    }
}

