/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.cloud;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.jboss.galleon.util.ZipUtils;
import org.wildfly.plugins.bootablejar.maven.cloud.JGroupsUtil;
import org.wildfly.plugins.bootablejar.maven.goals.BuildBootableJarMojo;

public class CloudConfig {
    private static final String OPENSHIFT = "openshift";
    private static final String KUBERNETES = "kubernetes";
    private boolean enableJgroupsPassword = false;
    String type = "openshift";

    public boolean getEnableJGroupsPassword() {
        return this.enableJgroupsPassword;
    }

    public void setEnableJGroupsPassword(boolean enableJgroupsPassword) {
        this.enableJgroupsPassword = enableJgroupsPassword;
    }

    public void validate() throws MojoExecutionException {
        if (this.type != null) {
            if (OPENSHIFT.equals(this.type) || KUBERNETES.equals(this.type)) {
                return;
            }
            throw new MojoExecutionException("Invalid clud type " + this.type + ". Can be " + OPENSHIFT + "or" + KUBERNETES);
        }
        this.type = OPENSHIFT;
    }

    public void copyExtraContent(BuildBootableJarMojo mojo, Path wildflyDir, Path contentDir) throws IOException, UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        try (InputStream stream = CloudConfig.class.getResourceAsStream("logging.properties");){
            Path target = wildflyDir.resolve("standalone").resolve("configuration").resolve("logging.properties");
            Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        Path marker = contentDir.resolve(this.type + ".properties");
        Properties props = new Properties();
        try (FileOutputStream s = new FileOutputStream(marker.toFile());){
            props.store(s, this.type + " properties");
        }
        Path extensionJar = mojo.resolveArtifact("org.wildfly.plugins", "wildfly-jar-cloud-extension", mojo.retrievePluginVersion());
        ZipUtils.unzip((Path)extensionJar, (Path)contentDir);
    }

    public Set<String> getExtraLayers(BuildBootableJarMojo mojo) {
        HashSet<String> set = new HashSet<String>();
        set.add("observability");
        set.add("core-tools");
        return set;
    }

    public void addCLICommands(BuildBootableJarMojo mojo, List<String> commands) throws Exception {
        List lines;
        try (InputStream stream = CloudConfig.class.getResourceAsStream("openshift-interfaces-script.cli");){
            lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            commands.addAll(lines);
        }
        stream = CloudConfig.class.getResourceAsStream("openshift-tx-script.cli");
        var4_4 = null;
        try {
            lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            commands.addAll(lines);
        }
        catch (Throwable lines2) {
            var4_4 = lines2;
            throw lines2;
        }
        finally {
            if (stream != null) {
                if (var4_4 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable lines2) {
                        var4_4.addSuppressed(lines2);
                    }
                } else {
                    stream.close();
                }
            }
        }
        if (this.enableJgroupsPassword) {
            Path p = mojo.getJBossHome();
            Path config = p.resolve("standalone").resolve("configuration").resolve("standalone.xml");
            commands.addAll(JGroupsUtil.getAuthProtocolCommands(config));
        }
        stream = CloudConfig.class.getResourceAsStream("openshift-clustering-script.cli");
        var4_4 = null;
        try {
            lines = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            commands.addAll(lines);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (stream != null) {
                if (var4_4 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    stream.close();
                }
            }
        }
    }
}

