/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bombuilder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.wildfly.plugins.bombuilder.AddExclusion;
import org.wildfly.plugins.bombuilder.IncludeDependency;
import org.wildfly.plugins.bombuilder.OrderedProperties;
import org.wildfly.plugins.bombuilder.PomDependencyVersionsTransformer;

@Mojo(name="build-bom", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildBomMojo
extends AbstractMojo {
    private static final String WILDCARD = "*";
    @Parameter
    private Parent parent;
    @Parameter(required=true)
    private String bomGroupId;
    @Parameter(required=true)
    private String bomArtifactId;
    @Parameter(required=true)
    private String bomVersion;
    @Parameter(defaultValue="")
    private String bomName;
    @Parameter(defaultValue="")
    private String bomDescription;
    @Parameter
    private boolean licenses = false;
    @Parameter(defaultValue="bom-pom.xml")
    String outputFilename;
    @Parameter
    private List<AddExclusion> addExclusions;
    @Parameter
    private List<Dependency> excludeDependencies;
    @Parameter
    private List<IncludeDependency> includeDependencies;
    @Parameter
    private List<IncludeDependency> includeDependenciesTransitives;
    @Parameter
    private List<Dependency> importDependencies;
    @Parameter
    private List<Dependency> versionRefDependencies;
    @Parameter
    private boolean includeTransitives = true;
    @Parameter
    private boolean bomWithDependencies = false;
    @Parameter(defaultValue="NONE")
    private InheritExclusions inheritExclusions;
    @Parameter
    private Set<String> includeProfiles;
    @Parameter
    private Set<String> includePlugins;
    @Parameter
    private Set<String> includeRepositories;
    @Component
    MavenProject mavenProject;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySystemSession;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Component
    private ProjectDependenciesResolver projectDependenciesResolver;
    private final PomDependencyVersionsTransformer versionsTransformer;
    private final ModelWriter modelWriter;

    public BuildBomMojo() {
        this(new ModelWriter(), new PomDependencyVersionsTransformer());
    }

    public BuildBomMojo(ModelWriter modelWriter, PomDependencyVersionsTransformer versionsTransformer) {
        this.versionsTransformer = versionsTransformer;
        this.modelWriter = modelWriter;
    }

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Generating BOM");
        }
        Model model = this.initializeModel();
        this.addDependencyManagement(model);
        this.finalizeModel(model);
    }

    private Model initializeModel() {
        Model currModel;
        MavenProject current;
        Model pomModel = new Model();
        pomModel.setModelVersion("4.0.0");
        pomModel.setGroupId(this.bomGroupId);
        pomModel.setArtifactId(this.bomArtifactId);
        pomModel.setVersion(this.bomVersion);
        pomModel.setPackaging("pom");
        pomModel.setName(this.bomName);
        pomModel.setDescription(this.bomDescription);
        pomModel.setProperties((Properties)new OrderedProperties());
        pomModel.getProperties().setProperty("project.build.sourceEncoding", "UTF-8");
        if (this.licenses) {
            pomModel.setLicenses(this.mavenProject.getLicenses());
        }
        if (this.parent != null) {
            if (this.parent.getGroupId() == null) {
                throw new IllegalArgumentException("No groupId was set for the parent");
            }
            if (this.parent.getArtifactId() == null) {
                throw new IllegalArgumentException("No artifactId was set for the parent");
            }
            if (this.parent.getVersion() == null) {
                for (MavenProject current2 = this.mavenProject; current2 != null; current2 = current2.getParent()) {
                    if (!current2.getGroupId().equals(this.parent.getGroupId()) || !current2.getArtifactId().equals(this.parent.getArtifactId())) continue;
                    this.parent.setVersion(current2.getVersion());
                    break;
                }
                if (this.parent.getVersion() == null) {
                    throw new IllegalArgumentException("No version was set for the parent " + this.parent.getGroupId() + ":" + this.parent.getArtifactId() + " and it cannot be determined from the parents of the consuming pom");
                }
            }
            pomModel.setParent(this.parent);
        }
        if (this.includeProfiles != null && !this.includeProfiles.isEmpty()) {
            HashSet<String> addedProfiles = new HashSet<String>();
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (current = this.mavenProject; current != null; current = current.getParent()) {
                currModel = current.getModel();
                if (currModel == null || currModel.getProfiles() == null) continue;
                for (Profile profile : currModel.getProfiles()) {
                    if (!this.includeProfiles.contains(profile.getId()) || addedProfiles.contains(profile.getId())) continue;
                    profiles.add(profile);
                    addedProfiles.add(profile.getId());
                }
            }
            if (profiles.size() > 0) {
                pomModel.setProfiles(profiles);
            }
        }
        if (this.includeRepositories != null) {
            HashSet<String> addedRepositories = new HashSet<String>();
            HashSet<String> addedPluginRepositories = new HashSet<String>();
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            ArrayList<Repository> pluginRepositories = new ArrayList<Repository>();
            for (MavenProject current3 = this.mavenProject; current3 != null; current3 = current3.getParent()) {
                Model currModel2 = current3.getModel();
                if (currModel2 == null) continue;
                if (currModel2.getRepositories() != null) {
                    for (Repository repository : currModel2.getRepositories()) {
                        if (!this.includeRepositories.isEmpty() && !this.includeRepositories.contains(repository.getId()) || addedRepositories.contains(repository.getId())) continue;
                        repositories.add(repository);
                        addedRepositories.add(repository.getId());
                    }
                }
                if (currModel2.getPluginRepositories() == null) continue;
                for (Repository pluginRepository : currModel2.getPluginRepositories()) {
                    if (!this.includeRepositories.isEmpty() && !this.includeRepositories.contains(pluginRepository.getId()) || addedPluginRepositories.contains(pluginRepository.getId())) continue;
                    pluginRepositories.add(pluginRepository);
                    addedPluginRepositories.add(pluginRepository.getId());
                }
            }
            if (repositories.size() > 0) {
                pomModel.setRepositories(repositories);
            }
            if (pluginRepositories.size() > 0) {
                pomModel.setPluginRepositories(pluginRepositories);
            }
        }
        if (this.includePlugins != null && !this.includePlugins.isEmpty()) {
            HashSet<String> addedPlugins = new HashSet<String>();
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            for (current = this.mavenProject; current != null; current = current.getParent()) {
                PluginManagement pluginManagement;
                Build build;
                currModel = current.getModel();
                if (currModel == null || (build = currModel.getBuild()) == null || (pluginManagement = build.getPluginManagement()) == null || pluginManagement.getPlugins() == null) continue;
                for (Plugin plugin : pluginManagement.getPlugins()) {
                    if (this.includePlugins.contains(plugin.getArtifactId()) && addedPlugins.add(plugin.getArtifactId())) {
                        plugins.add(plugin);
                        continue;
                    }
                    String ga = plugin.getGroupId() + ":" + plugin.getArtifactId();
                    if (!this.includePlugins.contains(ga) || !addedPlugins.add(ga)) continue;
                    plugins.add(plugin);
                }
            }
            if (plugins.size() > 0) {
                PluginManagement pluginManagement;
                Build build = pomModel.getBuild();
                if (build == null) {
                    build = new Build();
                    pomModel.setBuild(build);
                }
                if ((pluginManagement = build.getPluginManagement()) == null) {
                    pluginManagement = new PluginManagement();
                    build.setPluginManagement(pluginManagement);
                }
                pluginManagement.setPlugins(plugins);
            }
        }
        return pomModel;
    }

    private void finalizeModel(Model model) throws MojoExecutionException {
        if (model.getDependencyManagement() != null) {
            model = this.versionsTransformer.transformPomModel(model);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Dependencies versions converted to properties");
            }
        }
        File file = new File(this.mavenProject.getBuild().getDirectory(), this.outputFilename);
        this.modelWriter.writeModel(model, file);
        org.apache.maven.artifact.DefaultArtifact pomArtifact = new org.apache.maven.artifact.DefaultArtifact(this.bomGroupId, this.bomArtifactId, this.bomVersion, null, "pom", null, this.artifactHandlerManager.getArtifactHandler("pom"));
        pomArtifact.setFile(file);
        this.mavenProject.addAttachedArtifact((Artifact)pomArtifact);
    }

    private void addDependencyManagement(Model pomModel) throws MojoExecutionException {
        if (this.mavenProject.getDependencyManagement() == null || this.mavenProject.getDependencyManagement().getDependencies() == null) {
            return;
        }
        pomModel.setDependencyManagement(new DependencyManagement());
        TreeMap<String, Dependency> managedDependenciesMap = new TreeMap<String, Dependency>();
        ArrayList<Dependency> orderedManagedDependencies = new ArrayList<Dependency>();
        HashSet<String> managedExclusions = new HashSet<String>();
        ArrayList<String> includedManagedDependencies = new ArrayList<String>();
        ArrayList<String> includedManagedDependenciesWithTransitives = new ArrayList<String>();
        for (Dependency dependency : this.mavenProject.getDependencyManagement().getDependencies()) {
            if (this.isExcludedDependency(dependency) && this.getIncludedTransitiveDependency(dependency) == null) {
                this.getLog().info((CharSequence)("Skipping dependency excluded by config: " + dependency.getManagementKey()));
                continue;
            }
            this.addBuilderManagedDependency(dependency, orderedManagedDependencies, managedDependenciesMap, includedManagedDependencies, includedManagedDependenciesWithTransitives, managedExclusions);
        }
        if (this.includeDependenciesTransitives != null) {
            for (IncludeDependency includeDependencyTransitives : this.includeDependenciesTransitives) {
                boolean transitive = includeDependencyTransitives.getTransitive() == null ? this.includeTransitives : includeDependencyTransitives.getTransitive();
                Dependency dependency = (Dependency)managedDependenciesMap.get(includeDependencyTransitives.getManagementKey());
                if (this.isExcludedDependency(dependency)) {
                    this.getLog().info((CharSequence)("Skipping dependency excluded by config: " + dependency.getManagementKey()));
                    managedDependenciesMap.remove(dependency.getManagementKey());
                }
                for (Dependency dependency2 : this.getDependencyTransitives(dependency)) {
                    if (!managedDependenciesMap.containsKey(dependency2.getManagementKey()) || this.isExcludedDependency(dependency2)) continue;
                    String managementKey = dependency2.getManagementKey();
                    includedManagedDependencies.add(managementKey);
                    if (transitive) {
                        includedManagedDependenciesWithTransitives.add(managementKey);
                        this.getLog().debug((CharSequence)("Dependency transitive included (with transitives) by config: " + managementKey));
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Dependency transitive included (without transitives) by config: " + managementKey));
                }
            }
        }
        if (this.versionRefDependencies != null) {
            for (Dependency dependency : this.versionRefDependencies) {
                Dependency versionRef = (Dependency)managedDependenciesMap.get(dependency.getVersion());
                if (versionRef == null) {
                    throw new MojoExecutionException("Dependency " + dependency.getManagementKey() + " version ref " + dependency.getVersion() + " not found");
                }
                dependency.setVersion(versionRef.getVersion());
                this.addBuilderManagedDependency(dependency, orderedManagedDependencies, managedDependenciesMap, includedManagedDependencies, includedManagedDependenciesWithTransitives, managedExclusions);
            }
        }
        if (this.includeDependencies != null) {
            for (IncludeDependency includeDependency : this.includeDependencies) {
                String dependencyKey;
                if (WILDCARD.equals(includeDependency.getGroupId()) || WILDCARD.equals(includeDependency.getArtifactId()) || WILDCARD.equals(includeDependency.getType()) || WILDCARD.equals(includeDependency.getClassifier()) || includedManagedDependencies.contains(dependencyKey = includeDependency.getManagementKey()) || includedManagedDependenciesWithTransitives.contains(dependencyKey)) continue;
                throw new MojoExecutionException("Dependency to include " + dependencyKey + " not found in builder's dependency management");
            }
        }
        for (Dependency dependency : managedDependenciesMap.values()) {
            switch (this.inheritExclusions) {
                case ALL: {
                    break;
                }
                case NONE: {
                    dependency.setExclusions(null);
                    break;
                }
                case UNMANAGED: {
                    if (dependency.getExclusions().isEmpty()) break;
                    ArrayList<Exclusion> filteredExclusions = new ArrayList<Exclusion>();
                    for (Exclusion exclusion : dependency.getExclusions()) {
                        if (managedExclusions.contains(exclusion.getGroupId() + ":" + exclusion.getArtifactId())) {
                            if (!this.getLog().isDebugEnabled()) continue;
                            this.getLog().debug((CharSequence)("Removing exclusion " + exclusion.getGroupId().trim() + ":" + exclusion.getArtifactId().trim() + " from dependency " + dependency.getManagementKey()));
                            continue;
                        }
                        filteredExclusions.add(exclusion);
                    }
                    dependency.setExclusions(filteredExclusions);
                }
            }
            this.addExclusions(dependency);
        }
        ArrayList<Dependency> bomManagedDependencies = new ArrayList<Dependency>();
        ArrayList<Dependency> bomDependencies = new ArrayList<Dependency>();
        if (this.includeDependencies != null || this.includeDependenciesTransitives != null) {
            if (!includedManagedDependenciesWithTransitives.isEmpty()) {
                MavenProject clone = this.mavenProject.clone();
                clone.setDependencyArtifacts(null);
                clone.getDependencyManagement().setDependencies(new ArrayList<Dependency>(orderedManagedDependencies));
                clone.setDependencies(new ArrayList());
                for (String managementKey : includedManagedDependencies) {
                    Dependency dependency = ((Dependency)managedDependenciesMap.get(managementKey)).clone();
                    dependency.setExclusions(null);
                    if ("import".equals(dependency.getScope())) {
                        dependency.setScope("compile");
                    }
                    if (!includedManagedDependenciesWithTransitives.contains(managementKey)) {
                        Exclusion exclusion = new Exclusion();
                        exclusion.setGroupId(WILDCARD);
                        exclusion.setArtifactId(WILDCARD);
                        dependency.getExclusions().add(exclusion);
                    }
                    clone.getDependencies().add(dependency);
                }
                try {
                    for (org.eclipse.aether.graph.Dependency aDependency : this.projectDependenciesResolver.resolve((DependencyResolutionRequest)new DefaultDependencyResolutionRequest(clone, this.repositorySystemSession)).getDependencies()) {
                        Dependency dependency = new Dependency();
                        dependency.setGroupId(StringUtils.trim((String)aDependency.getArtifact().getGroupId()));
                        dependency.setArtifactId(StringUtils.trim((String)aDependency.getArtifact().getArtifactId()));
                        dependency.setType(StringUtils.trim((String)aDependency.getArtifact().getExtension()));
                        String resolvedClassifier = StringUtils.trim((String)aDependency.getArtifact().getClassifier());
                        if (resolvedClassifier != null && !resolvedClassifier.isEmpty()) {
                            dependency.setClassifier(resolvedClassifier);
                        }
                        dependency.setVersion(aDependency.getArtifact().getVersion());
                        Dependency managedDependency = (Dependency)managedDependenciesMap.get(dependency.getManagementKey());
                        this.addBomManagedDependency(managedDependency, bomManagedDependencies);
                        if (!this.bomWithDependencies) continue;
                        this.addBomDependency(managedDependency, bomDependencies);
                    }
                }
                catch (Throwable e) {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
            } else {
                for (String managementKey : includedManagedDependencies) {
                    Dependency managedDependency = (Dependency)managedDependenciesMap.get(managementKey);
                    this.addBomManagedDependency(managedDependency, bomManagedDependencies);
                    if (!this.bomWithDependencies) continue;
                    this.addBomDependency(managedDependency, bomDependencies);
                }
            }
        } else {
            for (Dependency managedDependency : orderedManagedDependencies) {
                this.addBomManagedDependency(managedDependency, bomManagedDependencies);
                if (!this.bomWithDependencies) continue;
                this.addBomDependency(managedDependency, bomDependencies);
            }
        }
        pomModel.getDependencyManagement().setDependencies(bomManagedDependencies);
        this.getLog().info((CharSequence)("Added " + pomModel.getDependencyManagement().getDependencies().size() + " managed dependencies to BOM."));
        pomModel.setDependencies(bomDependencies);
        this.getLog().info((CharSequence)("Added " + pomModel.getDependencies().size() + " dependencies to BOM."));
    }

    private void addBuilderManagedDependency(Dependency dependency, List<Dependency> orderedManagedDependencies, Map<String, Dependency> managedDependenciesMap, List<String> includedManagedDependencies, List<String> includedManagedDependenciesWithTransitives, Set<String> managedExclusions) {
        dependency = dependency.clone();
        String managementKey = dependency.getManagementKey();
        managedDependenciesMap.put(managementKey, dependency);
        orderedManagedDependencies.add(dependency);
        IncludeDependency includedDependency = this.getIncludedDependency(dependency);
        if (includedDependency != null) {
            boolean transitive = includedDependency.getTransitive() == null ? this.includeTransitives : includedDependency.getTransitive();
            includedManagedDependencies.add(managementKey);
            if (transitive) {
                includedManagedDependenciesWithTransitives.add(managementKey);
                this.getLog().debug((CharSequence)("Dependency included (with transitives) by config: " + managementKey));
            } else {
                this.getLog().debug((CharSequence)("Dependency included (without transitives) by config: " + managementKey));
            }
        }
        if (this.isImportedDependency(dependency)) {
            dependency.setScope("import");
            includedManagedDependencies.add(managementKey);
            this.getLog().debug((CharSequence)("Dependency imported by config: " + managementKey));
        }
        if (this.inheritExclusions == InheritExclusions.UNMANAGED) {
            managedExclusions.add(dependency.getGroupId() + ":" + dependency.getArtifactId());
        }
    }

    private void addBomManagedDependency(Dependency managedDependency, List<Dependency> bomManagedDependencies) {
        if (managedDependency != null) {
            managedDependency = managedDependency.clone();
            bomManagedDependencies.add(managedDependency);
            this.getLog().info((CharSequence)("Managed dependency " + managedDependency.getManagementKey() + " added to BOM."));
        }
    }

    private void addBomDependency(Dependency dependency, List<Dependency> bomDependencies) {
        if (dependency == null) {
            return;
        }
        if ("import".equals(dependency.getScope())) {
            return;
        }
        Dependency bomDependency = dependency.clone();
        bomDependency.setExclusions(null);
        bomDependency.setVersion(null);
        if ("compile".equals(bomDependency.getScope())) {
            bomDependency.setScope(null);
        }
        bomDependencies.add(bomDependency);
        this.getLog().info((CharSequence)("Dependency " + bomDependency.getManagementKey() + " added to BOM."));
    }

    private boolean isExcludedDependency(Dependency dependency) {
        Dependency dependencyMatch = this.getDependencyMatch(dependency, this.excludeDependencies);
        if (dependencyMatch != null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Managed dependency " + dependency.getManagementKey() + " matches dependency exclude " + dependencyMatch.getManagementKey()));
            }
            return true;
        }
        return false;
    }

    private IncludeDependency getIncludedTransitiveDependency(Dependency dependency) {
        return this.getDependencyMatch(dependency, this.includeDependenciesTransitives);
    }

    private IncludeDependency getIncludedDependency(Dependency dependency) {
        return this.getDependencyMatch(dependency, this.includeDependencies);
    }

    private Collection<? extends Dependency> getDependencyTransitives(Dependency dependency) throws MojoExecutionException {
        ArrayList<Dependency> transitives = new ArrayList<Dependency>();
        try {
            DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
            if (this.repositorySystem.resolveArtifact(this.repositorySystemSession, new ArtifactRequest().setRepositories(this.repositories).setArtifact((org.eclipse.aether.artifact.Artifact)artifact)).isMissing()) {
                throw new MojoExecutionException("Artifact for dependency " + dependency.getManagementKey() + " is missing, unable to retrieve dependencies");
            }
            for (org.eclipse.aether.graph.Dependency aDependency : this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, new ArtifactDescriptorRequest().setRepositories(this.repositories).setArtifact((org.eclipse.aether.artifact.Artifact)artifact)).getDependencies()) {
                Dependency transitive = new Dependency();
                transitive.setGroupId(StringUtils.trim((String)aDependency.getArtifact().getGroupId()));
                transitive.setArtifactId(StringUtils.trim((String)aDependency.getArtifact().getArtifactId()));
                transitive.setType(StringUtils.trim((String)aDependency.getArtifact().getExtension()));
                String resolvedClassifier = StringUtils.trim((String)aDependency.getArtifact().getClassifier());
                if (resolvedClassifier != null && !resolvedClassifier.isEmpty()) {
                    transitive.setClassifier(resolvedClassifier);
                }
                transitives.add(transitive);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return transitives;
    }

    private boolean isImportedDependency(Dependency dependency) {
        if (!"pom".equals(dependency.getType())) {
            return false;
        }
        Dependency dependencyMatch = this.getDependencyMatch(dependency, this.importDependencies);
        if (dependencyMatch != null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Managed dependency " + dependency.getManagementKey() + " matches dependency import " + dependencyMatch.getManagementKey()));
            }
            return true;
        }
        return false;
    }

    private <T extends Dependency> T getDependencyMatch(Dependency dependency, Collection<? extends T> dependencyMatches) {
        if (dependencyMatches != null && !dependencyMatches.isEmpty()) {
            for (Dependency dependencyMatch : dependencyMatches) {
                if (!this.matchesDependency(dependency, dependencyMatch)) continue;
                return (T)dependencyMatch;
            }
        }
        return null;
    }

    private boolean matchesDependency(Dependency dependency, Dependency match) {
        String classifier;
        String type;
        String artifactId;
        String groupId;
        if (!WILDCARD.equals(match.getGroupId()) && !(groupId = StringUtils.defaultString((Object)StringUtils.trim((String)dependency.getGroupId()), (String)"")).equals(match.getGroupId())) {
            return false;
        }
        if (!WILDCARD.equals(match.getArtifactId()) && !(artifactId = StringUtils.defaultString((Object)StringUtils.trim((String)dependency.getArtifactId()), (String)"")).equals(match.getArtifactId())) {
            return false;
        }
        if (!WILDCARD.equals(match.getType()) && !(type = StringUtils.defaultString((Object)StringUtils.trim((String)dependency.getType()), (String)"jar")).equals(match.getType())) {
            return false;
        }
        return WILDCARD.equals(match.getClassifier()) || !((classifier = StringUtils.trim((String)dependency.getClassifier())) == null ? match.getClassifier() != null : match.getClassifier() == null || !classifier.equals(match.getClassifier()));
    }

    private void addExclusions(Dependency dependency) {
        if (this.addExclusions != null) {
            for (AddExclusion exclusion : this.addExclusions) {
                if (!exclusion.getDependencyGroupId().equals(dependency.getGroupId()) || !exclusion.getDependencyArtifactId().equals(dependency.getArtifactId())) continue;
                Exclusion ex = new Exclusion();
                ex.setGroupId(exclusion.getExclusionGroupId());
                ex.setArtifactId(exclusion.getExclusionArtifactId());
                dependency.addExclusion(ex);
            }
        }
    }

    static class ModelWriter {
        ModelWriter() {
        }

        void writeModel(Model pomModel, File outputFile) throws MojoExecutionException {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            try (FileWriter writer = new FileWriter(outputFile);){
                MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
                mavenWriter.write((Writer)writer, pomModel);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException("Unable to write pom file.", (Exception)e);
            }
        }
    }

    public static enum InheritExclusions {
        ALL,
        NONE,
        UNMANAGED;

    }
}

