/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.beanmanager;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.SchemaManager;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jboss.as.jpa.beanmanager.IntegrationWithCDIBagImpl;
import org.jboss.as.jpa.beanmanager.PersistenceCdiExtension;
import org.jboss.as.jpa.container.TransactionScopedEntityManager;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jipijapa.plugin.spi.IntegrationWithCDIBag;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class IntegratePersistenceAfterBeanDiscovery
implements PersistenceCdiExtension {
    private static final Set<String> DEFAULT_QUALIFIERS = Set.of(Default.class.getName(), Any.class.getName());
    private final CopyOnWriteArrayList<IntegrationWithCDIBagImpl> persistenceUnitIntegrationStuff = new CopyOnWriteArrayList();
    private final Map<Class<?>, Collection<Set<String>>> foundProducers = new HashMap();
    private volatile boolean afterBeanDiscoveryEventRanAlready = false;
    private static final String transactionScoped = "jakarta.transaction.TransactionScoped";

    public void processProducerFields(@Observes ProcessProducerField<?, ?> producerField) {
        this.processBeanProducer(producerField.getBean());
    }

    public void processProducerMethods(@Observes ProcessProducerMethod<?, ?> processProducerMethod) {
        this.processBeanProducer(processProducerMethod.getBean());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        this.afterBeanDiscoveryEventRanAlready = true;
        try {
            this.addBeans(event);
        }
        catch (RuntimeException e) {
            event.addDefinitionError((Throwable)e);
        }
        finally {
            this.persistenceUnitIntegrationStuff.clear();
        }
    }

    public IntegrationWithCDIBagImpl register(PersistenceUnitMetadata persistenceUnitMetadata) {
        if (this.afterBeanDiscoveryEventRanAlready) {
            throw JpaLogger.ROOT_LOGGER.afterBeanDiscoveryEventRanAlready(persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
        }
        IntegrationWithCDIBagImpl integrationWithCDIBag = new IntegrationWithCDIBagImpl();
        integrationWithCDIBag.setPersistenceUnitMetadata(persistenceUnitMetadata);
        this.persistenceUnitIntegrationStuff.add(integrationWithCDIBag);
        return integrationWithCDIBag;
    }

    public void addBeans(AfterBeanDiscovery afterBeanDiscovery) {
        for (IntegrationWithCDIBagImpl integrationWithCDIBag : this.persistenceUnitIntegrationStuff) {
            PersistenceUnitMetadata persistenceUnitMetadata = integrationWithCDIBag.getPersistenceUnitMetadata();
            List qualifiers = Collections.emptyList();
            if (persistenceUnitMetadata.getQualifierAnnotationNames().size() > 0) {
                qualifiers = persistenceUnitMetadata.getQualifierAnnotationNames();
            }
            this.entityManager(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, (IntegrationWithCDIBag)integrationWithCDIBag);
            this.entityManagerFactory(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, (IntegrationWithCDIBag)integrationWithCDIBag);
            this.criteriaBuilder(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, (IntegrationWithCDIBag)integrationWithCDIBag);
            this.persistenceUnitUtil(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, (IntegrationWithCDIBag)integrationWithCDIBag);
            this.cache(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, (IntegrationWithCDIBag)integrationWithCDIBag);
            this.metamodel(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, (IntegrationWithCDIBag)integrationWithCDIBag);
            this.schemaManager(afterBeanDiscovery, persistenceUnitMetadata, qualifiers, integrationWithCDIBag);
        }
        this.foundProducers.clear();
    }

    private void entityManager(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBag integrationWithCDIBag) {
        if (this.producerExists(EntityManager.class, qualifiers)) {
            return;
        }
        String scope = persistenceUnitMetadata.getScopeAnnotationName();
        if (scope == null || scope.isEmpty()) {
            scope = transactionScoped;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(EntityManager.class);
        Class<Annotation> scopeAnnotation = null;
        try {
            scopeAnnotation = persistenceUnitMetadata.getClassLoader().loadClass(scope).asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException e) {
            throw JpaLogger.ROOT_LOGGER.classNotFound(e, "EntityManager", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
        }
        beanConfigurator.scope(scopeAnnotation);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "EntityManager", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(EntityManager.class);
        beanConfigurator.produceWith(c -> new TransactionScopedEntityManager(persistenceUnitMetadata.getScopedPersistenceUnitName(), new HashMap(), integrationWithCDIBag.getEntityManagerFactory(), SynchronizationType.SYNCHRONIZED, integrationWithCDIBag.getTransactionSynchronizationRegistry(), integrationWithCDIBag.getTransactionManager()));
    }

    private void entityManagerFactory(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBag integrationWithCDIBag) {
        if (this.producerExists(EntityManagerFactory.class, qualifiers)) {
            return;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(EntityManagerFactory.class);
        if (!persistenceUnitMetadata.isDuplicate()) {
            beanConfigurator.name(persistenceUnitMetadata.getPersistenceUnitName());
        } else {
            JpaLogger.ROOT_LOGGER.willNotNameEntityManagerFactoryBean(persistenceUnitMetadata.getScopedPersistenceUnitName(), persistenceUnitMetadata.getPersistenceUnitName());
        }
        beanConfigurator.scope(ApplicationScoped.class);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "EntityManagerFactory", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(EntityManagerFactory.class);
        beanConfigurator.produceWith(c -> integrationWithCDIBag.getEntityManagerFactory());
    }

    private void criteriaBuilder(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBag integrationWithCDIBag) {
        if (this.producerExists(CriteriaBuilder.class, qualifiers)) {
            return;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(CriteriaBuilder.class);
        beanConfigurator.scope(Dependent.class);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "CriteriaBuilder", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(CriteriaBuilder.class);
        beanConfigurator.produceWith(c -> integrationWithCDIBag.getEntityManagerFactory().getCriteriaBuilder());
    }

    private void persistenceUnitUtil(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBag integrationWithCDIBag) {
        if (this.producerExists(PersistenceUnitUtil.class, qualifiers)) {
            return;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(PersistenceUnitUtil.class);
        beanConfigurator.scope(Dependent.class);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "PersistenceUnitUtil", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(PersistenceUnitUtil.class);
        beanConfigurator.produceWith(c -> integrationWithCDIBag.getEntityManagerFactory().getPersistenceUnitUtil());
    }

    private void cache(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBag integrationWithCDIBag) {
        if (this.producerExists(Cache.class, qualifiers)) {
            return;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(Cache.class);
        beanConfigurator.scope(Dependent.class);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "Cache", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(Cache.class);
        beanConfigurator.produceWith(c -> integrationWithCDIBag.getEntityManagerFactory().getCache());
    }

    private void metamodel(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBag integrationWithCDIBag) {
        if (this.producerExists(Metamodel.class, qualifiers)) {
            return;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(Metamodel.class);
        beanConfigurator.scope(Dependent.class);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "Metamodel", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(Metamodel.class);
        beanConfigurator.produceWith(c -> integrationWithCDIBag.getEntityManagerFactory().getMetamodel());
    }

    private void schemaManager(AfterBeanDiscovery afterBeanDiscovery, PersistenceUnitMetadata persistenceUnitMetadata, List<String> qualifiers, IntegrationWithCDIBagImpl integrationWithCDIBag) {
        if (this.producerExists(SchemaManager.class, qualifiers)) {
            return;
        }
        BeanConfigurator beanConfigurator = afterBeanDiscovery.addBean();
        beanConfigurator.addTransitiveTypeClosure(SchemaManager.class);
        beanConfigurator.scope(Dependent.class);
        for (String qualifier : qualifiers) {
            Class<Annotation> qualifierType;
            try {
                qualifierType = persistenceUnitMetadata.getClassLoader().loadClass(qualifier).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                throw JpaLogger.ROOT_LOGGER.classNotFound(e, "SchemaManager", persistenceUnitMetadata.getPersistenceUnitName(), persistenceUnitMetadata.getScopedPersistenceUnitName());
            }
            beanConfigurator.addQualifier(ScopeProxy.createProxy(qualifierType));
        }
        beanConfigurator.beanClass(SchemaManager.class);
        beanConfigurator.produceWith(c -> integrationWithCDIBag.getEntityManagerFactory().getSchemaManager());
    }

    private void processBeanProducer(Bean<?> bean) {
        this.addProducerType(bean, EntityManager.class);
        this.addProducerType(bean, EntityManagerFactory.class);
        this.addProducerType(bean, CriteriaBuilder.class);
        this.addProducerType(bean, PersistenceUnitUtil.class);
        this.addProducerType(bean, Metamodel.class);
        this.addProducerType(bean, SchemaManager.class);
    }

    private void addProducerType(Bean<?> bean, Class<?> type) {
        if (bean.getTypes().contains(type)) {
            Collection qualifiers = this.foundProducers.computeIfAbsent(type, ignore -> new ArrayList());
            qualifiers.add(bean.getQualifiers().stream().map(a -> a.annotationType().getName()).collect(Collectors.toSet()));
        }
    }

    private boolean producerExists(Class<?> type, Collection<String> qualifiers) {
        Collection<Set<String>> allQualifiers = this.foundProducers.get(type);
        if (allQualifiers != null) {
            for (Set<String> q : allQualifiers) {
                if (qualifiers.isEmpty() && DEFAULT_QUALIFIERS.containsAll(q)) {
                    return true;
                }
                if (!q.containsAll(qualifiers)) continue;
                return true;
            }
        }
        return false;
    }

    protected record ScopeProxy(Class<? extends Annotation> annotationType) implements InvocationHandler
    {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("annotationType")) {
                return this.annotationType;
            }
            if (method.getName().equals("equals") && args != null && args.length == 1) {
                return this.annotationType.getName().equals(args[0].getClass().getName());
            }
            if (method.getName().equals("hashCode") && (args == null || args.length == 0)) {
                return this.annotationType.hashCode();
            }
            return method.getDefaultValue();
        }

        static <T extends Annotation> T createProxy(Class<T> annotationType) {
            return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new ScopeProxy(annotationType)));
        }
    }
}

