/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.text.DecimalFormat;
import java.util.Formatter;
import java.util.ResourceBundle;

public class Messages {
    private static final String CODE = "WFOPENSSL";
    public static Messages MESSAGES = new Messages();
    private static final String MSG1 = Messages.formatCode(1);
    private static final String MSG2 = Messages.formatCode(2);
    private static final String MSG3 = Messages.formatCode(3);
    private static final String MSG4 = Messages.formatCode(4);
    private static final String MSG5 = Messages.formatCode(5);
    private static final String MSG6 = Messages.formatCode(6);
    private static final String MSG7 = Messages.formatCode(7);
    private static final String MSG8 = Messages.formatCode(8);
    private static final String MSG9 = Messages.formatCode(9);
    private static final String MSG10 = Messages.formatCode(10);
    private static final String MSG11 = Messages.formatCode(11);
    private static final String MSG12 = Messages.formatCode(12);
    private static final String MSG13 = Messages.formatCode(13);
    private ResourceBundle properties = ResourceBundle.getBundle("org.wildfly.openssl.OpenSSLMessages");

    private static String formatCode(int i) {
        return CODE + new DecimalFormat("0000").format(i);
    }

    private Messages() {
    }

    private String interpolate(String messageid, Object ... arguments) {
        StringBuilder sb = new StringBuilder(messageid);
        sb.append(' ');
        new Formatter(sb).format(this.properties.getString(messageid), arguments);
        return sb.toString();
    }

    public String couldNotFindLibSSL(String systemProperty, String attempted) {
        return this.interpolate(MSG1, systemProperty, attempted);
    }

    public String openSSLVersion(String version) {
        return this.interpolate(MSG2, version);
    }

    public String couldNotFindLibCrypto(String systemProperty, String attempted) {
        return this.interpolate(MSG3, systemProperty, attempted);
    }

    public String noSslContext() {
        return this.interpolate(MSG4, new Object[0]);
    }

    public String sslWriteFailed(int sslWrote) {
        return this.interpolate(MSG5, sslWrote);
    }

    public String bufferIsNull() {
        return this.interpolate(MSG6, new Object[0]);
    }

    public String invalidOffset(int offset, int length, int arrayLength) {
        return this.interpolate(MSG7, offset, length, arrayLength);
    }

    public String readFromSSLFailed(long error, int lastPrimingReadResult, String err) {
        return this.interpolate(MSG8, error, lastPrimingReadResult, err);
    }

    public String inboundIsClosed() {
        return this.interpolate(MSG9, new Object[0]);
    }

    public String nullCipherSuites() {
        return this.interpolate(MSG10, new Object[0]);
    }

    public String emptyCipherSuiteList() {
        return this.interpolate(MSG11, new Object[0]);
    }

    public String failedCipherSuite(String cipherSuiteSpec) {
        return this.interpolate(MSG12, cipherSuiteSpec);
    }

    public String unsupportedProtocol(String p) {
        return this.interpolate(MSG13, p);
    }
}

