/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import org.wildfly.openssl.OpenSSLSessionContext;
import org.wildfly.openssl.SSL;

public final class OpenSSLClientSessionContext
extends OpenSSLSessionContext {
    OpenSSLClientSessionContext(long context) {
        super(context);
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        SSL.getInstance().setSessionCacheTimeout(this.context, seconds);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSL.getInstance().getSessionCacheTimeout(this.context);
    }

    @Override
    public void setSessionCacheSize(int size) {
    }

    @Override
    public int getSessionCacheSize() {
        return 0;
    }

    @Override
    public void setSessionCacheEnabled(boolean enabled) {
    }

    @Override
    public boolean isSessionCacheEnabled() {
        return true;
    }
}

