/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.PrintStream;
import org.eclipse.transformer.action.impl.ChangesImpl;
import org.slf4j.Logger;

public class ServiceLoaderConfigChangesImpl
extends ChangesImpl {
    private int changedProviders;
    private int unchangedProviders;

    public ServiceLoaderConfigChangesImpl() {
        this.clearChanges();
    }

    @Override
    public boolean hasNonResourceNameChanges() {
        return this.changedProviders > 0;
    }

    @Override
    public void clearChanges() {
        this.changedProviders = 0;
        this.unchangedProviders = 0;
        super.clearChanges();
    }

    public void addChangedProvider() {
        ++this.changedProviders;
    }

    public int getChangedProviders() {
        return this.changedProviders;
    }

    public void addUnchangedProvider() {
        ++this.unchangedProviders;
    }

    public int getUnchangedProviders() {
        return this.unchangedProviders;
    }

    @Override
    public void displayVerbose(PrintStream printStream, String inputPath, String outputPath) {
        printStream.printf("Input  [ %s ] as [ %s ]\n", this.getInputResourceName(), inputPath);
        printStream.printf("Output [ %s ] as [ %s ]\n", this.getOutputResourceName(), outputPath);
        printStream.printf("Replacements [ %s ]\n", this.getChangedProviders());
    }

    @Override
    public void displayVerbose(Logger logger, String inputPath, String outputPath) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        logger.info("Input  [ {} ] as [ {} ]", (Object)this.getInputResourceName(), (Object)inputPath);
        logger.info("Output [ {} ] as [ {} ]", (Object)this.getOutputResourceName(), (Object)outputPath);
        logger.info("Replacements [ {} ]", (Object)this.getChangedProviders());
    }
}

