/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ScheduledThreadPoolAdd;
import org.jboss.as.threads.ScheduledThreadPoolMetricsHandler;
import org.jboss.as.threads.ScheduledThreadPoolRemove;
import org.jboss.as.threads.ScheduledThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolResourceDescriptionResolver;
import org.jboss.as.threads.ThreadsExtension;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolResourceDefinition
extends PersistentResourceDefinition {
    private final ScheduledThreadPoolWriteAttributeHandler writeAttributeHandler;
    private final ScheduledThreadPoolMetricsHandler metricsHandler;
    private final boolean registerRuntimeOnly;

    public static ScheduledThreadPoolResourceDefinition create(boolean registerRuntimeOnly) {
        return ScheduledThreadPoolResourceDefinition.create("scheduled-thread-pool", ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static ScheduledThreadPoolResourceDefinition create(String type, ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase, boolean registerRuntimeOnly) {
        ScheduledThreadPoolAdd addHandler = new ScheduledThreadPoolAdd(threadFactoryResolver, serviceNameBase);
        return new ScheduledThreadPoolResourceDefinition(type, addHandler, serviceNameBase, registerRuntimeOnly);
    }

    private ScheduledThreadPoolResourceDefinition(String type, ScheduledThreadPoolAdd addHandler, ServiceName serviceNameBase, boolean registerRuntimeOnly) {
        super(PathElement.pathElement((String)type), (ResourceDescriptionResolver)new ThreadPoolResourceDescriptionResolver("scheduled-thread-pool", ThreadsExtension.RESOURCE_NAME, ThreadsExtension.class.getClassLoader()), (OperationStepHandler)addHandler, (OperationStepHandler)new ScheduledThreadPoolRemove(addHandler));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.writeAttributeHandler = new ScheduledThreadPoolWriteAttributeHandler(serviceNameBase);
        this.metricsHandler = new ScheduledThreadPoolMetricsHandler(serviceNameBase);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        this.writeAttributeHandler.registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            this.metricsHandler.registerAttributes(resourceRegistration);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(this.writeAttributeHandler.attributes);
    }
}

