/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolManagementUtils;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class UnboundedQueueThreadPoolAdd
extends AbstractAddStepHandler {
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.THREAD_FACTORY};
    private final ThreadFactoryResolver threadFactoryResolver;
    private final ServiceName serviceNameBase;
    private final RuntimeCapability<Void> capability;
    private final boolean allowCoreThreadTimeout;

    public UnboundedQueueThreadPoolAdd(ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase) {
        this(threadFactoryResolver, serviceNameBase, null, false);
    }

    public UnboundedQueueThreadPoolAdd(ThreadFactoryResolver threadFactoryResolver, ServiceName serviceNameBase, RuntimeCapability<Void> capability, boolean allowCoreThreadTimeout) {
        this.threadFactoryResolver = threadFactoryResolver;
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
        this.allowCoreThreadTimeout = allowCoreThreadTimeout;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolManagementUtils.BaseThreadPoolParameters params = ThreadPoolManagementUtils.parseUnboundedQueueThreadPoolParameters(context, operation, model);
        UnboundedQueueThreadPoolService service = new UnboundedQueueThreadPoolService(this.allowCoreThreadTimeout, params.getMaxThreads(), params.getKeepAliveTime());
        ThreadPoolManagementUtils.installThreadPoolService(service, params.getName(), this.capability, context.getCurrentAddress(), this.serviceNameBase, params.getThreadFactory(), this.threadFactoryResolver, service.getThreadFactoryInjector(), null, null, null, context.getServiceTarget());
    }

    ServiceName getServiceNameBase() {
        return this.serviceNameBase;
    }

    ThreadFactoryResolver getThreadFactoryResolver() {
        return this.threadFactoryResolver;
    }

    RuntimeCapability<Void> getCapability() {
        return this.capability;
    }
}

