/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.BoundedQueueThreadPoolService;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolManagementUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class BoundedQueueThreadPoolAdd
extends AbstractAddStepHandler {
    static final AttributeDefinition[] BLOCKING_ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.THREAD_FACTORY, PoolAttributeDefinitions.CORE_THREADS, PoolAttributeDefinitions.QUEUE_LENGTH, PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT};
    static final AttributeDefinition[] NON_BLOCKING_ATTRIBUTES = new AttributeDefinition[BLOCKING_ATTRIBUTES.length + 1];
    static final AttributeDefinition[] RW_ATTRIBUTES = new AttributeDefinition[]{PoolAttributeDefinitions.KEEPALIVE_TIME, PoolAttributeDefinitions.MAX_THREADS, PoolAttributeDefinitions.CORE_THREADS, PoolAttributeDefinitions.QUEUE_LENGTH, PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT};
    private final boolean blocking;
    private final ThreadFactoryResolver threadFactoryResolver;
    private final HandoffExecutorResolver handoffExecutorResolver;
    private final ServiceName serviceNameBase;
    private final RuntimeCapability<Void> capability;

    public BoundedQueueThreadPoolAdd(boolean blocking, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName serviceNameBase) {
        this(blocking, threadFactoryResolver, handoffExecutorResolver, serviceNameBase, null);
    }

    public BoundedQueueThreadPoolAdd(boolean blocking, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName serviceNameBase, RuntimeCapability<Void> capability) {
        this.blocking = blocking;
        this.threadFactoryResolver = threadFactoryResolver;
        this.handoffExecutorResolver = handoffExecutorResolver;
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolManagementUtils.BoundedThreadPoolParameters params = ThreadPoolManagementUtils.parseBoundedThreadPoolParameters(context, operation, model, this.blocking);
        BoundedQueueThreadPoolService service = new BoundedQueueThreadPoolService(params.getCoreThreads(), params.getMaxThreads(), params.getQueueLength(), this.blocking, params.getKeepAliveTime(), params.isAllowCoreTimeout());
        ThreadPoolManagementUtils.installThreadPoolService(service, params.getName(), this.capability, context.getCurrentAddress(), this.serviceNameBase, params.getThreadFactory(), this.threadFactoryResolver, service.getThreadFactoryInjector(), params.getHandoffExecutor(), this.handoffExecutorResolver, this.blocking ? null : service.getHandoffExecutorInjector(), context.getServiceTarget());
    }

    boolean isBlocking() {
        return this.blocking;
    }

    ServiceName getServiceNameBase() {
        return this.serviceNameBase;
    }

    ThreadFactoryResolver getThreadFactoryResolver() {
        return this.threadFactoryResolver;
    }

    HandoffExecutorResolver getHandoffExecutorResolver() {
        return this.handoffExecutorResolver;
    }

    static {
        System.arraycopy(BLOCKING_ATTRIBUTES, 0, NON_BLOCKING_ATTRIBUTES, 0, BLOCKING_ATTRIBUTES.length);
        BoundedQueueThreadPoolAdd.NON_BLOCKING_ATTRIBUTES[BoundedQueueThreadPoolAdd.NON_BLOCKING_ATTRIBUTES.length - 1] = PoolAttributeDefinitions.HANDOFF_EXECUTOR;
    }
}

