/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadPoolMetricsHandler;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class UnboundedQueueThreadPoolMetricsHandler
extends ThreadPoolMetricsHandler {
    public static final List<AttributeDefinition> METRICS = Arrays.asList(PoolAttributeDefinitions.ACTIVE_COUNT, PoolAttributeDefinitions.COMPLETED_TASK_COUNT, PoolAttributeDefinitions.CURRENT_THREAD_COUNT, PoolAttributeDefinitions.LARGEST_THREAD_COUNT, PoolAttributeDefinitions.REJECTED_COUNT, PoolAttributeDefinitions.TASK_COUNT, PoolAttributeDefinitions.QUEUE_SIZE);

    public UnboundedQueueThreadPoolMetricsHandler(ServiceName serviceNameBase) {
        this(null, serviceNameBase);
    }

    public UnboundedQueueThreadPoolMetricsHandler(RuntimeCapability capability, ServiceName serviceNameBase) {
        super(METRICS, capability, serviceNameBase);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) throws OperationFailedException {
        UnboundedQueueThreadPoolService pool = (UnboundedQueueThreadPoolService)service;
        switch (attributeName) {
            case "active-count": {
                context.getResult().set(pool.getActiveCount());
                break;
            }
            case "completed-task-count": {
                context.getResult().set(pool.getCompletedTaskCount());
                break;
            }
            case "current-thread-count": {
                context.getResult().set(pool.getCurrentThreadCount());
                break;
            }
            case "largest-thread-count": {
                context.getResult().set(pool.getLargestThreadCount());
                break;
            }
            case "rejected-count": {
                context.getResult().set(pool.getRejectedCount());
                break;
            }
            case "task-count": {
                context.getResult().set(pool.getTaskCount());
                break;
            }
            case "queue-size": {
                context.getResult().set(pool.getQueueSize());
                break;
            }
            default: {
                throw ThreadsLogger.ROOT_LOGGER.unsupportedUnboundedQueueThreadPoolMetric(attributeName);
            }
        }
    }
}

