/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedQueueExecutorService;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EventListener;
import org.jboss.threads.QueueExecutor;

public class BoundedQueueThreadPoolService
implements Service<ManagedQueueExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final InjectedValue<Executor> handoffExecutorValue = new InjectedValue();
    private ManagedQueueExecutorService executor;
    private int coreThreads;
    private int maxThreads;
    private int queueLength;
    private boolean blocking;
    private TimeSpec keepAlive;
    private boolean allowCoreTimeout;

    public BoundedQueueThreadPoolService(int coreThreads, int maxThreads, int queueLength, boolean blocking, TimeSpec keepAlive, boolean allowCoreTimeout) {
        this.coreThreads = coreThreads;
        this.maxThreads = maxThreads;
        this.queueLength = queueLength;
        this.blocking = blocking;
        this.keepAlive = keepAlive;
        this.allowCoreTimeout = allowCoreTimeout;
    }

    public synchronized void start(StartContext context) throws StartException {
        TimeSpec keepAliveSpec = this.keepAlive;
        long keepAliveTime = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getUnit().toNanos(keepAliveSpec.getDuration());
        QueueExecutor queueExecutor = new QueueExecutor(this.coreThreads, this.maxThreads, keepAliveTime, TimeUnit.NANOSECONDS, this.queueLength, (ThreadFactory)this.threadFactoryValue.getValue(), this.blocking, (Executor)this.handoffExecutorValue.getOptionalValue());
        queueExecutor.setAllowCoreThreadTimeout(this.allowCoreTimeout);
        this.executor = new ManagedQueueExecutorService(queueExecutor);
    }

    public synchronized void stop(StopContext context) {
        ManagedQueueExecutorService executor = this.getValue();
        context.asynchronous();
        executor.internalShutdown();
        executor.addShutdownListener(new EventListener<StopContext>(){

            public void handleEvent(StopContext stopContext) {
                stopContext.complete();
            }
        }, context);
        this.executor = null;
    }

    public synchronized ManagedQueueExecutorService getValue() throws IllegalStateException {
        ManagedQueueExecutorService value = this.executor;
        if (value == null) {
            throw ThreadsLogger.ROOT_LOGGER.boundedQueueThreadPoolExecutorUninitialized();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public Injector<Executor> getHandoffExecutorInjector() {
        return this.handoffExecutorValue;
    }

    public synchronized void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
        ManagedQueueExecutorService executor = this.executor;
        if (executor != null) {
            executor.setCoreThreads(coreThreads);
        }
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        ManagedQueueExecutorService executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
    }

    public synchronized void setKeepAlive(TimeSpec keepAlive) {
        this.keepAlive = keepAlive;
        ManagedQueueExecutorService executor = this.executor;
        if (executor != null) {
            executor.setKeepAlive(keepAlive);
        }
    }

    public synchronized void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.allowCoreTimeout = allowCoreTimeout;
        ManagedQueueExecutorService executor = this.executor;
        if (executor != null) {
            executor.setAllowCoreTimeout(allowCoreTimeout);
        }
    }

    public int getCurrentThreadCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getCurrentThreadCount();
    }

    public int getLargestThreadCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getLargestThreadCount();
    }

    TimeUnit getKeepAliveUnit() {
        return this.keepAlive == null ? TimeSpec.DEFAULT_KEEPALIVE.getUnit() : this.keepAlive.getUnit();
    }

    public int getRejectedCount() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getRejectedCount();
    }

    public int getQueueSize() {
        ManagedQueueExecutorService executor = this.getValue();
        return executor.getQueueSize();
    }
}

