/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.as.controller.Feature;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.xml.SubsystemResourceRegistrationXMLElement;
import org.jboss.as.controller.persistence.xml.SubsystemResourceXMLElementReader;
import org.jboss.as.controller.persistence.xml.SubsystemResourceXMLElementWriter;
import org.jboss.as.controller.persistence.xml.SubsystemResourceXMLSchema;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.common.Assert;

public interface SubsystemPersistence<S extends SubsystemSchema<S>> {
    public Set<S> getSchemas();

    default public XMLElementReader<List<ModelNode>> getReader(S schema) {
        return schema;
    }

    public XMLElementWriter<SubsystemMarshallingContext> getWriter(Stability var1);

    public static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema) {
        return SubsystemPersistence.of(EnumSet.of(currentSchema));
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(Set<S> currentSchemas) {
        Assert.assertFalse((boolean)currentSchemas.isEmpty());
        final Class schemaClass = ((Enum)currentSchemas.iterator().next()).getDeclaringClass();
        final EnumMap elements = new EnumMap(schemaClass);
        for (Enum currentSchema : currentSchemas) {
            elements.put(currentSchema, ((SubsystemResourceXMLSchema)currentSchema).getSubsystemXMLElement());
        }
        final Map currentSchemaPerStability = Feature.map(currentSchemas);
        return new SubsystemPersistence<S>(){

            @Override
            public Set<S> getSchemas() {
                return EnumSet.allOf(schemaClass);
            }

            @Override
            public XMLElementReader<List<ModelNode>> getReader(S schema) {
                return Optional.ofNullable((SubsystemResourceRegistrationXMLElement)elements.get(schema)).map(SubsystemResourceXMLElementReader::new).orElse((XMLElementReader)schema);
            }

            @Override
            public XMLElementWriter<SubsystemMarshallingContext> getWriter(Stability stability) {
                Enum currentSchema = (Enum)currentSchemaPerStability.get(stability);
                return new SubsystemResourceXMLElementWriter((SubsystemResourceRegistrationXMLElement)elements.get(currentSchema));
            }
        };
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema, XMLElementWriter<SubsystemMarshallingContext> writer) {
        return SubsystemPersistence.of(Map.of(currentSchema, writer));
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(final Map<S, XMLElementWriter<SubsystemMarshallingContext>> currentWriters) {
        Assert.assertFalse((boolean)currentWriters.isEmpty());
        final Class schemaClass = ((Enum)currentWriters.keySet().iterator().next()).getDeclaringClass();
        final Map currentSchemas = Feature.map(currentWriters.keySet());
        return new SubsystemPersistence<S>(){

            @Override
            public Set<S> getSchemas() {
                return EnumSet.allOf(schemaClass);
            }

            @Override
            public XMLElementWriter<SubsystemMarshallingContext> getWriter(Stability stability) {
                Enum currentSchema = (Enum)currentSchemas.get(stability);
                return (XMLElementWriter)currentWriters.get(currentSchema);
            }
        };
    }
}

