/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.QuaternaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.TernaryCapabilityNameResolver;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.ResourceResolver;
import org.wildfly.subsystem.resource.SimpleResource;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.NaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public interface ResourceCapabilityReference<T>
extends CapabilityReference<T>,
ResourceModelResolver<ServiceDependency<T>> {
    public Function<PathAddress, String[]> getRequirementNameResolver();

    public void addCapabilityRequirements(OperationContext var1, Resource var2);

    public void removeCapabilityRequirements(OperationContext var1, Resource var2);

    default public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        this.addCapabilityRequirements(context, resource);
    }

    default public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        this.removeCapabilityRequirements(context, resource);
    }

    public static <T> Builder<T> builder(RuntimeCapability<Void> capability, NullaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement), ResourceCapabilityServiceDescriptorReference.EMPTY_RESOLVER);
    }

    public static <T> NaryBuilder<T> builder(RuntimeCapability<Void> capability, UnaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement), (Function<PathAddress, String[]>)UnaryCapabilityNameResolver.DEFAULT);
    }

    public static <T> NaryBuilder<T> builder(RuntimeCapability<Void> capability, BinaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement), (Function<PathAddress, String[]>)BinaryCapabilityNameResolver.PARENT_CHILD);
    }

    public static <T> NaryBuilder<T> builder(RuntimeCapability<Void> capability, TernaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement), (Function<PathAddress, String[]>)TernaryCapabilityNameResolver.GRANDPARENT_PARENT_CHILD);
    }

    public static <T> NaryBuilder<T> builder(RuntimeCapability<Void> capability, QuaternaryServiceDescriptor<T> requirement) {
        return new DefaultBuilder<T>(capability, NaryServiceDescriptor.of(requirement), (Function<PathAddress, String[]>)QuaternaryCapabilityNameResolver.GREATGRANDPARENT_GRANDPARENT_PARENT_CHILD);
    }

    public static class DefaultBuilder<T>
    implements NaryBuilder<T> {
        private final RuntimeCapability<Void> capability;
        private final NaryServiceDescriptor<T> requirement;
        private Function<PathAddress, String[]> requirementNameResolver;
        private BiPredicate<OperationContext, Resource> predicate = ResourceCapabilityServiceDescriptorReference.ALWAYS;

        DefaultBuilder(RuntimeCapability<Void> capability, NaryServiceDescriptor<T> requirement, Function<PathAddress, String[]> defaultRequirementNameResolver) {
            this.capability = capability;
            this.requirement = requirement;
            this.requirementNameResolver = defaultRequirementNameResolver;
        }

        @Override
        public Builder<T> withRequirementNameResolver(Function<PathAddress, String[]> requirementNameResolver) {
            this.requirementNameResolver = requirementNameResolver;
            return this;
        }

        @Override
        public <V> Builder<T> when(final ResourceResolver<V> resolver, final Predicate<V> predicate) {
            this.predicate = new BiPredicate<OperationContext, Resource>(){

                @Override
                public boolean test(OperationContext context, Resource resource) {
                    try {
                        return predicate.test(resolver.resolve(context, resource));
                    }
                    catch (OperationFailedException e) {
                        return true;
                    }
                }
            };
            return this;
        }

        @Override
        public ResourceCapabilityReference<T> build() {
            return new ResourceCapabilityServiceDescriptorReference<T>(this.capability, this.requirement, this.requirementNameResolver, this.predicate);
        }
    }

    public static class ResourceCapabilityServiceDescriptorReference<T>
    extends AbstractResourceCapabilityServiceDescriptorReference<T> {
        static final Function<PathAddress, String[]> EMPTY_RESOLVER = address -> new String[0];
        private static final BiPredicate<OperationContext, Resource> ALWAYS = (context, resource) -> true;
        private final BiPredicate<OperationContext, Resource> predicate;

        ResourceCapabilityServiceDescriptorReference(RuntimeCapability<Void> capability, NaryServiceDescriptor<T> requirement, Function<PathAddress, String[]> requirementNameResolver, BiPredicate<OperationContext, Resource> predicate) {
            super(capability, requirement, requirementNameResolver);
            this.predicate = predicate;
        }

        @Override
        public ServiceDependency<T> resolve(OperationContext context, Resource resource) throws OperationFailedException {
            if (this.predicate.test(context, resource)) {
                Map.Entry<String, String[]> resolved = this.resolve(context, resource, "");
                return ServiceDependency.on(resolved.getKey(), this.getRequirement().getType(), resolved.getValue());
            }
            return ServiceDependency.empty();
        }

        @Override
        public ServiceDependency<T> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
            return this.resolve(context, new SimpleResource(model));
        }

        @Override
        public Map.Entry<String, String[]> resolve(OperationContext context, Resource resource, String value) {
            return this.getRequirement().resolve(this.getRequirementNameResolver().apply(context.getCurrentAddress()));
        }

        @Override
        public void addCapabilityRequirements(OperationContext context, Resource resource) {
            if (this.predicate.test(context, resource)) {
                context.registerAdditionalCapabilityRequirement(this.resolveRequirementName(context), this.resolveDependentName(context), null);
            }
        }

        @Override
        public void removeCapabilityRequirements(OperationContext context, Resource resource) {
            if (this.predicate.test(context, resource)) {
                context.deregisterCapabilityRequirement(this.resolveRequirementName(context), this.resolveDependentName(context));
            }
        }

        private String resolveRequirementName(OperationContext context) {
            Map.Entry<String, String[]> resolved = this.resolve(context, null, "");
            return resolved.getValue().length > 0 ? RuntimeCapability.buildDynamicCapabilityName((String)resolved.getKey(), (String[])resolved.getValue()) : resolved.getKey();
        }
    }

    public static abstract class AbstractResourceCapabilityServiceDescriptorReference<T>
    extends CapabilityReference.AbstractServiceDescriptorReference<T>
    implements ResourceCapabilityReference<T> {
        private final Function<PathAddress, String[]> requirementNameResolver;

        public AbstractResourceCapabilityServiceDescriptorReference(RuntimeCapability<Void> capability, NaryServiceDescriptor<T> requirement, Function<PathAddress, String[]> requirementNameResolver) {
            super(capability, requirement);
            this.requirementNameResolver = requirementNameResolver;
        }

        @Override
        public Function<PathAddress, String[]> getRequirementNameResolver() {
            return this.requirementNameResolver;
        }

        public String[] getRequirementPatternSegments(String name, PathAddress address) {
            String[] segments = this.requirementNameResolver.apply(address);
            for (int i = 0; i < segments.length; ++i) {
                String segment = segments[i];
                if (segment.charAt(0) != '$') continue;
                segments[i] = segment.substring(1);
            }
            return segments;
        }
    }

    public static interface NaryBuilder<T>
    extends Builder<T> {
        public Builder<T> withRequirementNameResolver(Function<PathAddress, String[]> var1);
    }

    public static interface Builder<T> {
        default public Builder<T> when(AttributeDefinition attribute, Predicate<ModelNode> predicate) {
            ResourceModelResolver<ModelNode> resolver = (arg_0, arg_1) -> ((AttributeDefinition)attribute).resolveModelAttribute(arg_0, arg_1);
            return this.when(resolver, predicate);
        }

        public <V> Builder<T> when(ResourceResolver<V> var1, Predicate<V> var2);

        public ResourceCapabilityReference<T> build();
    }
}

