/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service.capability;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.function.Functions;
import org.wildfly.service.AsyncServiceBuilder;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.AsyncCapabilityServiceBuilder;

public interface CapabilityServiceInstaller
extends ResourceServiceInstaller,
Installer<CapabilityServiceTarget> {
    public static <V> Builder<V, V> builder(RuntimeCapability<Void> capability, V value) {
        return (Builder)CapabilityServiceInstaller.builder(capability, Functions.constantSupplier(value)).startWhen(Installer.StartWhen.INSTALLED);
    }

    public static <V> Builder<V, V> builder(RuntimeCapability<Void> capability, ServiceDependency<V> dependency) {
        ServiceDependency<V> supplier = dependency;
        return (Builder)((Builder)CapabilityServiceInstaller.builder(capability, supplier).requires((Consumer)((Object)dependency))).startWhen(Installer.StartWhen.AVAILABLE);
    }

    public static <V> Builder<V, V> builder(RuntimeCapability<Void> capability, Supplier<V> factory) {
        return CapabilityServiceInstaller.builder(capability, Function.identity(), factory);
    }

    public static <T, V> Builder<T, V> builder(RuntimeCapability<Void> capability, Function<T, V> mapper, Supplier<T> factory) {
        return new DefaultBuilder<T, V>(capability, mapper, factory);
    }

    @Override
    default public Consumer<OperationContext> install(OperationContext context) {
        final ServiceController controller = this.install((ServiceTarget)context.getCapabilityServiceTarget());
        return new Consumer<OperationContext>(){

            @Override
            public void accept(OperationContext context) {
                context.removeService(controller);
            }
        };
    }

    public static interface Builder<T, V>
    extends Installer.BlockingBuilder<Builder<T, V>>,
    Installer.UnaryBuilder<Builder<T, V>, CapabilityServiceInstaller, CapabilityServiceTarget, RequirementServiceBuilder<?>, T, V> {
    }

    public static class DefaultBuilder<T, V>
    extends Installer.AbstractUnaryBuilder<Builder<T, V>, CapabilityServiceInstaller, CapabilityServiceTarget, CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>, T, V>
    implements Builder<T, V> {
        private volatile boolean blocking = false;

        DefaultBuilder(final RuntimeCapability<Void> capability, Function<T, V> mapper, Supplier<T> factory) {
            super(mapper, factory, new BiFunction<CapabilityServiceBuilder<?>, Collection<ServiceName>, Consumer<V>>(){

                @Override
                public Consumer<V> apply(CapabilityServiceBuilder<?> builder, Collection<ServiceName> names) {
                    return names.isEmpty() ? builder.provides(capability) : builder.provides(new RuntimeCapability[]{capability}, (ServiceName[])names.toArray(ServiceName[]::new));
                }
            });
        }

        public Builder<T, V> blocking() {
            this.blocking = true;
            return this;
        }

        public CapabilityServiceInstaller build() {
            final boolean blocking = this.blocking;
            final AsyncServiceBuilder.Async async = this.hasStopTask() ? AsyncServiceBuilder.Async.START_AND_STOP : AsyncServiceBuilder.Async.START_ONLY;
            return new DefaultCapabilityServiceInstaller((Installer.Configuration<CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>>)this, new Function<CapabilityServiceTarget, CapabilityServiceBuilder<?>>(){

                @Override
                public CapabilityServiceBuilder<?> apply(CapabilityServiceTarget target) {
                    AsyncCapabilityServiceBuilder builder = target.addService();
                    return blocking ? new AsyncCapabilityServiceBuilder(builder, async) : builder;
                }
            });
        }

        protected Builder<T, V> builder() {
            return this;
        }
    }

    public static class DefaultCapabilityServiceInstaller
    extends Installer.DefaultInstaller<CapabilityServiceTarget, CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>>
    implements CapabilityServiceInstaller {
        DefaultCapabilityServiceInstaller(Installer.Configuration<CapabilityServiceBuilder<?>, RequirementServiceBuilder<?>> config, Function<CapabilityServiceTarget, CapabilityServiceBuilder<?>> serviceBuilderFactory) {
            super(config, serviceBuilderFactory);
        }
    }
}

