/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.Map;
import org.wildfly.common.Assert;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.QuaternaryServiceDescriptor;
import org.wildfly.service.descriptor.ServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

interface NaryServiceDescriptor<T>
extends ServiceDescriptor<T> {
    public Map.Entry<String, String[]> resolve(String[] var1);

    public static <T> NaryServiceDescriptor<T> of(final NullaryServiceDescriptor<T> descriptor) {
        return new NaryServiceDescriptor<T>(){

            public String getName() {
                return descriptor.getName();
            }

            public Class<T> getType() {
                return descriptor.getType();
            }

            public <U extends T> NaryServiceDescriptor<U> asType(Class<U> type) {
                return NaryServiceDescriptor.of(descriptor.asType(type));
            }

            @Override
            public Map.Entry<String, String[]> resolve(String[] references) {
                Assert.checkArrayBounds((Object[])references, (int)0, (int)0);
                return descriptor.resolve();
            }
        };
    }

    public static <T> NaryServiceDescriptor<T> of(final UnaryServiceDescriptor<T> descriptor) {
        return new NaryServiceDescriptor<T>(){

            public String getName() {
                return descriptor.getName();
            }

            public Class<T> getType() {
                return descriptor.getType();
            }

            public <U extends T> NaryServiceDescriptor<U> asType(Class<U> type) {
                return NaryServiceDescriptor.of(descriptor.asType(type));
            }

            @Override
            public Map.Entry<String, String[]> resolve(String[] references) {
                Assert.checkArrayBounds((Object[])references, (int)0, (int)1);
                return descriptor.resolve(references[0]);
            }
        };
    }

    public static <T> NaryServiceDescriptor<T> of(final BinaryServiceDescriptor<T> descriptor) {
        return new NaryServiceDescriptor<T>(){

            public String getName() {
                return descriptor.getName();
            }

            public Class<T> getType() {
                return descriptor.getType();
            }

            public <U extends T> NaryServiceDescriptor<U> asType(Class<U> type) {
                return NaryServiceDescriptor.of(descriptor.asType(type));
            }

            @Override
            public Map.Entry<String, String[]> resolve(String[] references) {
                Assert.checkArrayBounds((Object[])references, (int)0, (int)2);
                return descriptor.resolve(references[0], references[1]);
            }
        };
    }

    public static <T> NaryServiceDescriptor<T> of(final TernaryServiceDescriptor<T> descriptor) {
        return new NaryServiceDescriptor<T>(){

            public String getName() {
                return descriptor.getName();
            }

            public Class<T> getType() {
                return descriptor.getType();
            }

            public <U extends T> NaryServiceDescriptor<U> asType(Class<U> type) {
                return NaryServiceDescriptor.of(descriptor.asType(type));
            }

            @Override
            public Map.Entry<String, String[]> resolve(String[] references) {
                Assert.checkArrayBounds((Object[])references, (int)0, (int)3);
                return descriptor.resolve(references[0], references[1], references[2]);
            }
        };
    }

    public static <T> NaryServiceDescriptor<T> of(final QuaternaryServiceDescriptor<T> descriptor) {
        return new NaryServiceDescriptor<T>(){

            public String getName() {
                return descriptor.getName();
            }

            public Class<T> getType() {
                return descriptor.getType();
            }

            public <U extends T> NaryServiceDescriptor<U> asType(Class<U> type) {
                return NaryServiceDescriptor.of(descriptor.asType(type));
            }

            @Override
            public Map.Entry<String, String[]> resolve(String[] references) {
                Assert.checkArrayBounds((Object[])references, (int)0, (int)4);
                return descriptor.resolve(references[0], references[1], references[2], references[3]);
            }
        };
    }
}

