/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.operation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.resource.AttributeTranslation;
import org.wildfly.subsystem.resource.operation.AddResourceOperationStepHandlerDescriptor;
import org.wildfly.subsystem.resource.operation.DescribedOperationStepHandler;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.resource.operation.WriteAttributeOperationStepHandler;

public class AddResourceOperationStepHandler
extends AbstractAddStepHandler
implements DescribedOperationStepHandler<AddResourceOperationStepHandlerDescriptor> {
    private final AddResourceOperationStepHandlerDescriptor descriptor;

    public AddResourceOperationStepHandler(AddResourceOperationStepHandlerDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime() && (this.descriptor.getRuntimeHandler().isPresent() || this.descriptor.getDeploymentChainContributor().isPresent());
    }

    @Override
    public AddResourceOperationStepHandlerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.getParent();
        PathElement path = address.getLastElement();
        OperationStepHandler parentHandler = context.getRootResourceRegistration().getOperationHandler(parentAddress, context.getCurrentOperationName());
        if (parentHandler instanceof AddResourceOperationStepHandlerDescriptor) {
            AddResourceOperationStepHandlerDescriptor parentDescriptor = (AddResourceOperationStepHandlerDescriptor)((DescribedOperationStepHandler)parentHandler).getDescriptor();
            if (parentDescriptor.getRequiredChildren().contains(path) && context.readResourceFromRoot(parentAddress, false).hasChild(path)) {
                context.addStep(Util.createRemoveOperation((PathAddress)address), context.getRootResourceRegistration().getOperationHandler(address, "remove"), OperationContext.Stage.MODEL);
                context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                return;
            }
            for (PathElement requiredPath : parentDescriptor.getRequiredSingletonChildren()) {
                Set childrenNames;
                String requiredPathKey = requiredPath.getKey();
                if (!requiredPath.getKey().equals(path.getKey()) || (childrenNames = context.readResourceFromRoot(parentAddress, false).getChildrenNames(requiredPathKey)).isEmpty()) continue;
                for (String childName : childrenNames) {
                    PathAddress singletonAddress = parentAddress.append(requiredPathKey, childName);
                    context.addStep(Util.createRemoveOperation((PathAddress)singletonAddress), context.getRootResourceRegistration().getOperationHandler(singletonAddress, "remove"), OperationContext.Stage.MODEL);
                }
                context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                return;
            }
        }
        super.execute(context, operation);
    }

    protected Resource createResource(OperationContext context) {
        Resource resource = Resource.Factory.create((boolean)context.getResourceRegistration().isRuntimeOnly());
        if (context.isDefaultRequiresRuntime()) {
            resource = (Resource)this.descriptor.getResourceTransformation().apply(resource);
        }
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        return resource;
    }

    protected Resource createResource(OperationContext context, ModelNode operation) {
        Integer index;
        UnaryOperator<Resource> transformation = context.isDefaultRequiresRuntime() ? this.descriptor.getResourceTransformation() : UnaryOperator.identity();
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        Resource resource = (Resource)transformation.apply(Resource.Factory.create((boolean)registration.isRuntimeOnly(), (Set)registration.getOrderedChildTypes()));
        Integer n = index = registration.isOrderedChildResource() && operation.hasDefined("add-index") ? operation.get("add-index").asIntOrNull() : null;
        if (index == null) {
            context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        } else {
            context.addResource(PathAddress.EMPTY_ADDRESS, index.intValue(), resource);
        }
        return resource;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress currentAddress = context.getCurrentAddress();
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        OperationDefinition operationDefinition = registration.getOperationEntry(PathAddress.EMPTY_ADDRESS, context.getCurrentOperationName()).getOperationDefinition();
        for (AttributeDefinition parameter : operationDefinition.getParameters()) {
            ImmutableManagementResourceRegistration targetRegistration;
            String sourceName;
            AttributeTranslation translation = this.descriptor.getAttributeTranslation(parameter);
            if (translation == null || !operation.hasDefined(sourceName = parameter.getName())) continue;
            ModelNode sourceValue = parameter.validateOperation(operation);
            ModelNode targetValue = translation.getWriteAttributeOperationTranslator().translate(context, sourceValue);
            AttributeDefinition targetAttribute = translation.getTargetAttribute();
            String targetName = targetAttribute.getName();
            PathAddress targetAddress = (PathAddress)translation.getPathAddressTranslator().apply(currentAddress);
            if (targetAddress == currentAddress) {
                if (operation.hasDefined(targetName)) continue;
                operation.get(targetName).set(targetValue);
                continue;
            }
            ModelNode writeAttributeOperation = Util.getWriteAttributeOperation((PathAddress)targetAddress, (String)targetAttribute.getName(), (ModelNode)targetValue);
            ImmutableManagementResourceRegistration immutableManagementResourceRegistration = targetRegistration = currentAddress == targetAddress ? registration : context.getRootResourceRegistration().getSubModel(targetAddress);
            if (targetRegistration == null) {
                throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.noSuchResourceType(targetAddress));
            }
            AttributeAccess targetAttributeAccess = targetRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, targetName);
            if (targetAttributeAccess == null) {
                throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.unknownAttribute(targetName));
            }
            OperationStepHandler writeAttributeHandler = targetAttributeAccess.getWriteHandler();
            if (writeAttributeHandler == null) {
                throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.attributeNotWritable(targetName));
            }
            context.addStep(writeAttributeOperation, writeAttributeHandler, OperationContext.Stage.MODEL);
        }
        ModelNode model = resource.getModel();
        Map attributes = registration.getAttributes(PathAddress.EMPTY_ADDRESS);
        for (AttributeDefinition parameter : operationDefinition.getParameters()) {
            if (this.descriptor.getAttributeTranslation(parameter) != null) continue;
            AttributeAccess attribute = (AttributeAccess)attributes.get(parameter.getName());
            if (attribute != null && AttributeAccess.Storage.CONFIGURATION.test(attribute)) {
                OperationStepHandler writeHandler = attribute.getWriteHandler();
                if (writeHandler != null && writeHandler.getClass() != WriteAttributeOperationStepHandler.class) {
                    ModelNode writeAttributeOperation = Util.getWriteAttributeOperation((PathAddress)currentAddress, (String)parameter.getName(), (ModelNode)parameter.validateOperation(operation));
                    context.addStep(writeAttributeOperation, writeHandler, OperationContext.Stage.MODEL);
                    continue;
                }
                parameter.validateAndSet(operation, model);
                continue;
            }
            parameter.validateOperation(operation);
        }
        AddResourceOperationStepHandler.addRequiredChildren(context, this.descriptor.getRequiredChildren(), Resource::hasChild);
        AddResourceOperationStepHandler.addRequiredChildren(context, this.descriptor.getRequiredSingletonChildren(), AddResourceOperationStepHandler::hasChildren);
        if (!model.isDefined()) {
            model.setEmptyObject();
        }
    }

    private static boolean hasChildren(Resource resource, PathElement path) {
        return resource.hasChildren(path.getKey());
    }

    private static void addRequiredChildren(OperationContext context, Collection<PathElement> paths, final BiPredicate<Resource, PathElement> present) {
        OperationStepHandler addIfAbsentHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                PathAddress address = context.getCurrentAddress();
                Resource parentResource = context.readResourceFromRoot(address.getParent(), false);
                if (!present.test(parentResource, address.getLastElement())) {
                    context.getResourceRegistration().getOperationHandler(PathAddress.EMPTY_ADDRESS, "add").execute(context, operation);
                }
            }
        };
        for (PathElement path : paths) {
            context.addStep(Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path})), addIfAbsentHandler, OperationContext.Stage.MODEL);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        final Consumer contributor = this.descriptor.getDeploymentChainContributor().orElse(null);
        if (contributor != null) {
            AbstractDeploymentChainStep deploymentChainStepHandler = new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget target) {
                    contributor.accept(target);
                }
            };
            context.addStep((OperationStepHandler)deploymentChainStepHandler, OperationContext.Stage.RUNTIME);
        }
        Set flags = context.getResourceRegistration().getOperationFlags(PathAddress.EMPTY_ADDRESS, context.getCurrentOperationName());
        if (context.isBooting() || flags.contains(OperationEntry.Flag.RESTART_NONE) || flags.contains(OperationEntry.Flag.RESTART_RESOURCE_SERVICES) && context.isResourceServiceRestartAllowed()) {
            ResourceOperationRuntimeHandler handler = this.descriptor.getRuntimeHandler().orElse(null);
            if (handler != null) {
                handler.addRuntime(context, resource);
            }
        } else if (flags.contains(OperationEntry.Flag.RESTART_JVM)) {
            context.restartRequired();
        } else {
            context.reloadRequired();
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        Set flags = context.getResourceRegistration().getOperationFlags(PathAddress.EMPTY_ADDRESS, context.getCurrentOperationName());
        if (context.isBooting() || flags.contains(OperationEntry.Flag.RESTART_NONE) || flags.contains(OperationEntry.Flag.RESTART_RESOURCE_SERVICES) && context.isResourceServiceRestartAllowed()) {
            ResourceOperationRuntimeHandler handler = this.descriptor.getRuntimeHandler().orElse(null);
            if (handler != null) {
                try {
                    handler.removeRuntime(context, resource);
                }
                catch (OperationFailedException e) {
                    throw new IllegalStateException(e);
                }
            }
        } else if (flags.contains(OperationEntry.Flag.RESTART_JVM)) {
            context.revertRestartRequired();
        } else {
            context.revertReloadRequired();
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ModelNode model = resource.getModel();
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        for (RuntimeCapability capability : registration.getCapabilities()) {
            if (!this.descriptor.getCapabilityFilter(capability).test(context, resource)) continue;
            context.registerCapability(capability.isDynamicallyNamed() ? capability.fromBaseCapability(address) : capability);
        }
        for (AttributeAccess attribute : registration.getAttributes(PathAddress.EMPTY_ADDRESS).values()) {
            if (AttributeAccess.Storage.RUNTIME.test(attribute) || AttributeAccess.Flag.ALIAS.test(attribute)) continue;
            AttributeDefinition definition = attribute.getAttributeDefinition();
            String attributeName = definition.getName();
            if (!definition.hasCapabilityRequirements()) continue;
            definition.addCapabilityRequirements(context, resource, model.get(attributeName));
        }
        for (CapabilityReferenceRecorder recorder : registration.getRequirements()) {
            recorder.addCapabilityRequirements(context, resource, null, new String[0]);
        }
    }
}

