/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.xml.Schema;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public interface SubsystemPersistence<S extends Schema> {
    public Set<S> getSchemas();

    public XMLElementReader<List<ModelNode>> getReader(S var1);

    public XMLElementWriter<SubsystemMarshallingContext> getWriter();

    public static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema) {
        PersistentResourceXMLDescription currentXMLDescription = ((PersistentSubsystemSchema)currentSchema).getXMLDescription();
        return SubsystemPersistence.of(currentSchema, (XMLElementReader<List<ModelNode>>)new PersistentResourceXMLDescriptionReader(currentXMLDescription), (XMLElementWriter<SubsystemMarshallingContext>)new PersistentResourceXMLDescriptionWriter(currentXMLDescription));
    }

    public static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema, XMLElementWriter<SubsystemMarshallingContext> writer) {
        return SubsystemPersistence.of(currentSchema, (XMLElementReader<List<ModelNode>>)((XMLElementReader)currentSchema), writer);
    }

    private static <S extends Enum<S>> SubsystemPersistence<S> of(S currentSchema, XMLElementReader<List<ModelNode>> currentReader, XMLElementWriter<SubsystemMarshallingContext> writer) {
        return SubsystemPersistence.of(EnumSet.allOf(currentSchema.getDeclaringClass()), Function.identity(), currentSchema, (XMLElementReader<List<ModelNode>>)((XMLElementReader)currentSchema), writer);
    }

    public static <S extends Schema, R extends XMLElementReader<List<ModelNode>>> SubsystemPersistence<S> of(Set<S> schemas, Function<S, R> readerFactory, XMLElementWriter<SubsystemMarshallingContext> writer) {
        return new DefaultSubsystemPersistence<S, R>(schemas, readerFactory, writer);
    }

    public static <S extends Schema, R extends XMLElementReader<List<ModelNode>>> SubsystemPersistence<S> of(final Set<S> schemas, final Function<S, R> readerFactory, final S currentSchema, final XMLElementReader<List<ModelNode>> currentReader, final XMLElementWriter<SubsystemMarshallingContext> writer) {
        return new DefaultSubsystemPersistence<S, R>(schemas, readerFactory, writer){

            @Override
            public Set<S> getSchemas() {
                return schemas;
            }

            @Override
            public XMLElementReader<List<ModelNode>> getReader(S schema) {
                return schema == currentSchema ? currentReader : (XMLElementReader)readerFactory.apply(schema);
            }

            @Override
            public XMLElementWriter<SubsystemMarshallingContext> getWriter() {
                return writer;
            }
        };
    }

    public static class DefaultSubsystemPersistence<S extends Schema, R extends XMLElementReader<List<ModelNode>>>
    implements SubsystemPersistence<S> {
        private final Set<S> schemas;
        private final Function<S, R> readerFactory;
        private final XMLElementWriter<SubsystemMarshallingContext> writer;

        DefaultSubsystemPersistence(Set<S> schemas, Function<S, R> readerFactory, XMLElementWriter<SubsystemMarshallingContext> writer) {
            this.schemas = schemas;
            this.readerFactory = readerFactory;
            this.writer = writer;
        }

        @Override
        public Set<S> getSchemas() {
            return this.schemas;
        }

        @Override
        public XMLElementReader<List<ModelNode>> getReader(S schema) {
            return (XMLElementReader)this.readerFactory.apply(schema);
        }

        @Override
        public XMLElementWriter<SubsystemMarshallingContext> getWriter() {
            return this.writer;
        }
    }
}

