/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RemoteDestinationOutboundSocketBindingAddHandler
extends AbstractAddStepHandler {
    static final RemoteDestinationOutboundSocketBindingAddHandler INSTANCE = new RemoteDestinationOutboundSocketBindingAddHandler();

    private RemoteDestinationOutboundSocketBindingAddHandler() {
        super(OutboundSocketBindingResourceDefinition.OUTBOUND_SOCKET_BINDING_CAPABILITY, (AttributeDefinition[])RemoteDestinationOutboundSocketBindingResourceDefinition.ATTRIBUTES);
    }

    protected boolean requiresRuntime(OperationContext context) {
        if (context.getProcessType().isServer()) {
            return super.requiresRuntime(context);
        }
        PathAddress pathAddress = context.getCurrentAddress();
        return pathAddress.size() > 0 && pathAddress.getElement(0).getKey().equals("host");
    }

    protected void populateModel(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String socketBindingGroupName = address.getParent().getLastElement().getValue();
        final String outboundSocketBindingName = address.getLastElement().getValue();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context2, ModelNode operation) throws OperationFailedException {
                if (!context2.getProcessType().isServer()) {
                    try {
                        Resource resource = context2.readResourceFromRoot(context2.getCurrentAddress().getParent(), false);
                        this.validation(socketBindingGroupName, outboundSocketBindingName, resource, true, new ArrayList<String>());
                    }
                    catch (Resource.NoSuchResourceException e) {
                        return;
                    }
                } else {
                    Resource resource = context2.readResourceFromRoot(PathAddress.pathAddress((String)"socket-binding-group", (String)socketBindingGroupName), false);
                    this.validation(socketBindingGroupName, outboundSocketBindingName, resource, false, new ArrayList<String>());
                }
            }

            private void validation(String socketBindingGroupName2, String outboundSocketBindingName2, Resource resource, boolean recursive, List<String> validatedGroupList) {
                Set socketBindingNames = resource.getChildrenNames("socket-binding");
                Set localDestinationOutboundSocketBindingNames = resource.getChildrenNames("local-destination-outbound-socket-binding");
                if (socketBindingNames.contains(outboundSocketBindingName2) || localDestinationOutboundSocketBindingNames.contains(outboundSocketBindingName2)) {
                    throw ControllerLogger.ROOT_LOGGER.socketBindingalreadyDeclared(Element.SOCKET_BINDING.getLocalName(), Element.OUTBOUND_SOCKET_BINDING.getLocalName(), outboundSocketBindingName2, Element.SOCKET_BINDING_GROUP.getLocalName(), socketBindingGroupName2);
                }
                validatedGroupList.add(socketBindingGroupName2);
                if (recursive && resource.getModel().hasDefined("includes")) {
                    List includedSocketBindingGroups = resource.getModel().get("includes").asList();
                    for (ModelNode includedSocketBindingGroup : includedSocketBindingGroups) {
                        String includedSocketBindingGroupName = includedSocketBindingGroup.asString();
                        if (validatedGroupList.contains(includedSocketBindingGroupName)) continue;
                        Resource includedResource = context.readResourceFromRoot(PathAddress.pathAddress((String)"socket-binding-group", (String)includedSocketBindingGroupName), false);
                        this.validation(includedSocketBindingGroupName, outboundSocketBindingName2, includedResource, recursive, validatedGroupList);
                    }
                }
            }
        }, OperationContext.Stage.MODEL);
        super.populateModel(context, operation, resource);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        RemoteDestinationOutboundSocketBindingAddHandler.installOutboundSocketBindingService(context, model);
    }

    static void installOutboundSocketBindingService(OperationContext context, ModelNode model) throws OperationFailedException {
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        String outboundSocketName = context.getCurrentAddressValue();
        String destinationHost = RemoteDestinationOutboundSocketBindingResourceDefinition.HOST.resolveModelAttribute(context, model).asString();
        int destinationPort = RemoteDestinationOutboundSocketBindingResourceDefinition.PORT.resolveModelAttribute(context, model).asInt();
        String sourceInterfaceName = OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.resolveModelAttribute(context, model).asStringOrNull();
        Integer sourcePort = OutboundSocketBindingResourceDefinition.SOURCE_PORT.resolveModelAttribute(context, model).asIntOrNull();
        boolean fixedSourcePort = OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.resolveModelAttribute(context, model).asBoolean();
        RemoteDestinationOutboundSocketBindingService outboundSocketBindingService = new RemoteDestinationOutboundSocketBindingService(outboundSocketName, destinationHost, destinationPort, sourcePort, fixedSourcePort);
        CapabilityServiceBuilder serviceBuilder = serviceTarget.addCapability(OutboundSocketBindingResourceDefinition.OUTBOUND_SOCKET_BINDING_CAPABILITY, (Service)outboundSocketBindingService);
        if (sourceInterfaceName != null) {
            serviceBuilder.addCapabilityRequirement("org.wildfly.network.interface", NetworkInterfaceBinding.class, outboundSocketBindingService.getSourceNetworkInterfaceBindingInjector(), new String[]{sourceInterfaceName});
        }
        serviceBuilder.addCapabilityRequirement("org.wildfly.management.socket-binding-manager", SocketBindingManager.class, outboundSocketBindingService.getSocketBindingManagerInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND).addAliases(new ServiceName[]{OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketName})}).install();
    }
}

