/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.nio.file.Path;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalInstallationReportHandler;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.operations.AbstractInstallationReporter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InstallationReportHandler
extends AbstractInstallationReporter {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("report", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setRuntimeOnly().setReadOnly().withFlags(new OperationEntry.Flag[]{OperationEntry.Flag.HIDDEN}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).setReplyType(ModelType.OBJECT).setReplyParameters(new AttributeDefinition[]{GlobalInstallationReportHandler.SUMMARY_DEFINITION}).build();
    private final ServerEnvironment environment;

    public static InstallationReportHandler createOperation(ServerEnvironment environment) {
        return new InstallationReportHandler(environment);
    }

    private InstallationReportHandler(ServerEnvironment environment) {
        this.environment = environment;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode installerInfo = new ModelNode();
        PathAddress installerAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"installer")});
        OperationEntry installerOpEntry = context.getRootResourceRegistration().getOperationEntry(installerAddress, "history");
        if (installerOpEntry != null) {
            context.addStep(installerInfo, Util.createOperation((String)"history", (PathAddress)installerAddress), installerOpEntry.getOperationHandler(), OperationContext.Stage.RUNTIME);
        }
        final Path installationDir = this.environment.getHomeDir().toPath();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode result = context.getResult();
                result.get(GlobalInstallationReportHandler.SUMMARY_DEFINITION.getName()).set(InstallationReportHandler.this.createProductNode(context, new AbstractInstallationReporter.InstallationConfiguration(InstallationReportHandler.this.environment, InstallationReportHandler.this.environment.getProductConfig(), installerInfo, installationDir)));
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

