/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import io.undertow.server.HttpHandler;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.domain.http.server.ConsoleAvailability;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.http.server.ManagementHttpRequestProcessor;
import org.jboss.as.domain.http.server.ManagementHttpServer;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.as.server.mgmt.domain.HttpManagement;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.MechanismConfigurationSelector;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.xnio.XnioWorker;

public class UndertowHttpManagementService
implements org.jboss.msc.service.Service<HttpManagement> {
    public static final RuntimeCapability<Void> EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.http.extensible", ExtensibleHttpManagement.class).build();
    public static final ServiceName SERVICE_NAME = EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY.getCapabilityServiceName();
    public static final String SERVER_NAME = "wildfly-managment";
    public static final String HTTP_MANAGEMENT = "http-management";
    public static final String HTTPS_MANAGEMENT = "https-management";
    public static final ServiceName HTTP_UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry", "http-management"});
    public static final ServiceName HTTPS_UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry", "https-management"});
    public static final String JBOSS_REMOTING = "jboss-remoting";
    public static final String MANAGEMENT_ENDPOINT = "management-endpoint";
    private final Consumer<HttpManagement> httpManagementConsumer;
    private final Supplier<ListenerRegistry> listenerRegistrySupplier;
    private final Supplier<ModelController> modelControllerSupplier;
    private final Supplier<SocketBinding> socketBindingSupplier;
    private final Supplier<SocketBinding> secureSocketBindingSupplier;
    private final Supplier<NetworkInterfaceBinding> interfaceBindingSupplier;
    private final Supplier<NetworkInterfaceBinding> secureInterfaceBindingSupplier;
    private final Supplier<SocketBindingManager> socketBindingManagerSupplier;
    private final Supplier<ManagementHttpRequestProcessor> requestProcessorSupplier;
    private final Supplier<XnioWorker> workerSupplier;
    private final Supplier<Executor> executorSupplier;
    private final Integer port;
    private final Integer securePort;
    private final Collection<String> allowedOrigins;
    private final Supplier<HttpAuthenticationFactory> httpAuthFactorySupplier;
    private final Supplier<SSLContext> sslContextSupplier;
    private final ConsoleMode consoleMode;
    private final Supplier<String> consoleSlot;
    private final Map<String, List<HttpInterfaceCommonPolicy.Header>> constantHeaders;
    private final Supplier<ConsoleAvailability> consoleAvailabilitySupplier;
    private final Supplier<SecurityDomain> virtualSecurityDomainSupplier;
    private final Supplier<HttpServerAuthenticationMechanismFactory> virtualMechanismFactorySupplier;
    private final Integer backlog;
    private final Integer noRequestTimeout;
    private final Integer connectionHighWater;
    private final Integer connectionLowWater;
    private ManagementHttpServer serverManagement;
    private SocketBindingManager socketBindingManager;
    private boolean useUnmanagedBindings = false;
    private ManagedBinding basicManagedBinding;
    private ManagedBinding secureManagedBinding;
    private ExtensibleHttpManagement httpManagement = new ExtensibleHttpManagement(){

        @Override
        public void addStaticContext(String contextName, ResourceManager resourceManager) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.addStaticContext(contextName, resourceManager);
        }

        @Override
        public void addManagementGetRemapContext(String contextName, final ExtensibleHttpManagement.PathRemapper remapper) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.addManagementGetRemapContext(contextName, new ManagementHttpServer.PathRemapper(){

                public String remapPath(String originalPath) {
                    return remapper.remapPath(originalPath);
                }
            });
        }

        @Override
        public void addManagementHandler(String contextName, boolean requiresSecurity, HttpHandler managementHandler) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.addManagementHandler(contextName, requiresSecurity, managementHandler);
        }

        @Override
        public void removeContext(String contextName) {
            Assert.assertNotNull((Object)UndertowHttpManagementService.this.serverManagement);
            UndertowHttpManagementService.this.serverManagement.removeContext(contextName);
        }

        public InetSocketAddress getHttpSocketAddress() {
            return UndertowHttpManagementService.this.basicManagedBinding == null ? null : UndertowHttpManagementService.this.basicManagedBinding.getBindAddress();
        }

        public InetSocketAddress getHttpsSocketAddress() {
            return UndertowHttpManagementService.this.secureManagedBinding == null ? null : UndertowHttpManagementService.this.secureManagedBinding.getBindAddress();
        }

        @Override
        public int getHttpPort() {
            if (UndertowHttpManagementService.this.basicManagedBinding != null) {
                return UndertowHttpManagementService.this.basicManagedBinding.getBindAddress().getPort();
            }
            return UndertowHttpManagementService.this.port != null ? UndertowHttpManagementService.this.port : -1;
        }

        @Override
        public NetworkInterfaceBinding getHttpNetworkInterfaceBinding() {
            NetworkInterfaceBinding binding;
            NetworkInterfaceBinding networkInterfaceBinding = binding = UndertowHttpManagementService.this.interfaceBindingSupplier != null ? UndertowHttpManagementService.this.interfaceBindingSupplier.get() : null;
            if (binding == null) {
                SocketBinding socketBinding;
                SocketBinding socketBinding2 = socketBinding = UndertowHttpManagementService.this.socketBindingSupplier != null ? UndertowHttpManagementService.this.socketBindingSupplier.get() : null;
                if (socketBinding != null) {
                    binding = socketBinding.getNetworkInterfaceBinding();
                }
            }
            return binding;
        }

        @Override
        public int getHttpsPort() {
            if (UndertowHttpManagementService.this.secureManagedBinding != null) {
                return UndertowHttpManagementService.this.secureManagedBinding.getBindAddress().getPort();
            }
            return UndertowHttpManagementService.this.securePort != null ? UndertowHttpManagementService.this.securePort : -1;
        }

        @Override
        public NetworkInterfaceBinding getHttpsNetworkInterfaceBinding() {
            NetworkInterfaceBinding binding;
            NetworkInterfaceBinding networkInterfaceBinding = binding = UndertowHttpManagementService.this.interfaceBindingSupplier != null ? UndertowHttpManagementService.this.interfaceBindingSupplier.get() : null;
            if (binding == null) {
                SocketBinding socketBinding;
                SocketBinding socketBinding2 = socketBinding = UndertowHttpManagementService.this.secureSocketBindingSupplier != null ? UndertowHttpManagementService.this.secureSocketBindingSupplier.get() : null;
                if (socketBinding != null) {
                    binding = socketBinding.getNetworkInterfaceBinding();
                }
            }
            return binding;
        }

        @Override
        public boolean hasConsole() {
            return UndertowHttpManagementService.this.consoleMode.hasConsole();
        }
    };

    public UndertowHttpManagementService(Consumer<HttpManagement> httpManagementConsumer, Supplier<ListenerRegistry> listenerRegistrySupplier, Supplier<ModelController> modelControllerSupplier, Supplier<SocketBinding> socketBindingSupplier, Supplier<SocketBinding> secureSocketBindingSupplier, Supplier<SocketBindingManager> socketBindingManagerSupplier, Supplier<NetworkInterfaceBinding> interfaceBindingSupplier, Supplier<NetworkInterfaceBinding> secureInterfaceBindingSupplier, Supplier<ManagementHttpRequestProcessor> requestProcessorSupplier, Supplier<XnioWorker> workerSupplier, Supplier<Executor> executorSupplier, Supplier<HttpAuthenticationFactory> httpAuthFactorySupplier, Supplier<SSLContext> sslContextSupplier, Integer port, Integer securePort, Collection<String> allowedOrigins, ConsoleMode consoleMode, Supplier<String> consoleSlot, Map<String, List<HttpInterfaceCommonPolicy.Header>> constantHeaders, Supplier<ConsoleAvailability> consoleAvailabilitySupplier, Integer backlog, Integer noRequestTimeout, Integer connectionHighWater, Integer connectionLowWater) {
        this(httpManagementConsumer, listenerRegistrySupplier, modelControllerSupplier, socketBindingSupplier, secureSocketBindingSupplier, socketBindingManagerSupplier, interfaceBindingSupplier, secureInterfaceBindingSupplier, requestProcessorSupplier, workerSupplier, executorSupplier, httpAuthFactorySupplier, sslContextSupplier, port, securePort, allowedOrigins, consoleMode, consoleSlot, constantHeaders, consoleAvailabilitySupplier, null, null, backlog, noRequestTimeout, connectionHighWater, connectionLowWater);
    }

    public UndertowHttpManagementService(Consumer<HttpManagement> httpManagementConsumer, Supplier<ListenerRegistry> listenerRegistrySupplier, Supplier<ModelController> modelControllerSupplier, Supplier<SocketBinding> socketBindingSupplier, Supplier<SocketBinding> secureSocketBindingSupplier, Supplier<SocketBindingManager> socketBindingManagerSupplier, Supplier<NetworkInterfaceBinding> interfaceBindingSupplier, Supplier<NetworkInterfaceBinding> secureInterfaceBindingSupplier, Supplier<ManagementHttpRequestProcessor> requestProcessorSupplier, Supplier<XnioWorker> workerSupplier, Supplier<Executor> executorSupplier, Supplier<HttpAuthenticationFactory> httpAuthFactorySupplier, Supplier<SSLContext> sslContextSupplier, Integer port, Integer securePort, Collection<String> allowedOrigins, ConsoleMode consoleMode, Supplier<String> consoleSlot, Map<String, List<HttpInterfaceCommonPolicy.Header>> constantHeaders, Supplier<ConsoleAvailability> consoleAvailabilitySupplier, Supplier<SecurityDomain> virtualSecurityDomainSupplier, Supplier<HttpServerAuthenticationMechanismFactory> virtualMechanismFactorySupplier, Integer backlog, Integer noRequestTimeout, Integer connectionHighWater, Integer connectionLowWater) {
        this.httpManagementConsumer = httpManagementConsumer;
        this.listenerRegistrySupplier = listenerRegistrySupplier;
        this.modelControllerSupplier = modelControllerSupplier;
        this.socketBindingSupplier = socketBindingSupplier;
        this.secureSocketBindingSupplier = secureSocketBindingSupplier;
        this.socketBindingManagerSupplier = socketBindingManagerSupplier;
        this.interfaceBindingSupplier = interfaceBindingSupplier;
        this.secureInterfaceBindingSupplier = secureInterfaceBindingSupplier;
        this.requestProcessorSupplier = requestProcessorSupplier;
        this.workerSupplier = workerSupplier;
        this.executorSupplier = executorSupplier;
        this.httpAuthFactorySupplier = httpAuthFactorySupplier;
        this.sslContextSupplier = sslContextSupplier;
        this.port = port;
        this.securePort = securePort;
        this.allowedOrigins = allowedOrigins;
        this.consoleMode = consoleMode;
        this.consoleSlot = consoleSlot;
        this.constantHeaders = constantHeaders;
        this.consoleAvailabilitySupplier = consoleAvailabilitySupplier;
        this.virtualSecurityDomainSupplier = virtualSecurityDomainSupplier;
        this.virtualMechanismFactorySupplier = virtualMechanismFactorySupplier;
        this.backlog = backlog;
        this.noRequestTimeout = noRequestTimeout;
        this.connectionHighWater = connectionHighWater;
        this.connectionLowWater = connectionLowWater;
    }

    public synchronized void start(StartContext context) throws StartException {
        NetworkInterfaceBinding secureInterfaceBinding;
        SSLContext sslContext;
        ModelController modelController = this.modelControllerSupplier.get();
        ConsoleAvailability consoleAvailability = this.consoleAvailabilitySupplier.get();
        this.socketBindingManager = this.socketBindingManagerSupplier != null ? this.socketBindingManagerSupplier.get() : null;
        HttpAuthenticationFactory httpAuthenticationFactory = this.httpAuthFactorySupplier != null ? this.httpAuthFactorySupplier.get() : null;
        SSLContext sSLContext = sslContext = this.sslContextSupplier != null ? this.sslContextSupplier.get() : null;
        if (sslContext == null) {
            Object var6_6 = null;
        }
        InetSocketAddress bindAddress = null;
        InetSocketAddress secureBindAddress = null;
        SocketBinding basicBinding = this.socketBindingSupplier != null ? this.socketBindingSupplier.get() : null;
        SocketBinding secureBinding = this.secureSocketBindingSupplier != null ? this.secureSocketBindingSupplier.get() : null;
        NetworkInterfaceBinding interfaceBinding = this.interfaceBindingSupplier != null ? this.interfaceBindingSupplier.get() : null;
        NetworkInterfaceBinding networkInterfaceBinding = secureInterfaceBinding = this.secureInterfaceBindingSupplier != null ? this.secureInterfaceBindingSupplier.get() : null;
        if (interfaceBinding != null) {
            this.useUnmanagedBindings = true;
            assert (this.port != null);
            int port = this.port;
            if (port > 0) {
                bindAddress = new InetSocketAddress(interfaceBinding.getAddress(), port);
            }
            assert (this.securePort != null);
            int securePort = this.securePort;
            if (securePort > 0) {
                InetAddress secureAddress = secureInterfaceBinding == null ? interfaceBinding.getAddress() : secureInterfaceBinding.getAddress();
                secureBindAddress = new InetSocketAddress(secureAddress, securePort);
            }
        } else {
            if (basicBinding != null) {
                bindAddress = basicBinding.getSocketAddress();
            }
            if (secureBinding != null) {
                secureBindAddress = secureBinding.getSocketAddress();
            }
        }
        ArrayList<ListenerRegistry.Listener> listeners = new ArrayList<ListenerRegistry.Listener>();
        if (bindAddress != null) {
            ListenerRegistry.Listener http = new ListenerRegistry.Listener("http", HTTP_MANAGEMENT, SERVER_NAME, bindAddress);
            http.setContextInformation("socket-binding", (Object)basicBinding);
            listeners.add(http);
        }
        if (secureBindAddress != null) {
            ListenerRegistry.Listener https = new ListenerRegistry.Listener("https", HTTPS_MANAGEMENT, SERVER_NAME, secureBindAddress);
            https.setContextInformation("socket-binding", (Object)secureBinding);
            listeners.add(https);
        }
        ChannelUpgradeHandler upgradeHandler = new ChannelUpgradeHandler();
        ServiceBuilder builder = context.getChildTarget().addService(HTTP_UPGRADE_SERVICE_NAME);
        Consumer upgradeHandlerConsumer = builder.provides(new ServiceName[]{HTTP_UPGRADE_SERVICE_NAME, HTTPS_UPGRADE_SERVICE_NAME});
        builder.addAliases(new ServiceName[]{HTTPS_UPGRADE_SERVICE_NAME});
        builder.setInstance(Service.newInstance((Consumer)upgradeHandlerConsumer, (Object)upgradeHandler));
        builder.install();
        for (ListenerRegistry.Listener listener : listeners) {
            listener.addHttpUpgradeMetadata(new ListenerRegistry.HttpUpgradeMetadata(JBOSS_REMOTING, MANAGEMENT_ENDPOINT));
        }
        if (this.listenerRegistrySupplier.get() != null) {
            for (ListenerRegistry.Listener listener : listeners) {
                this.listenerRegistrySupplier.get().addListener(listener);
            }
        }
        Long uploadLimit = Long.getLong("org.wildfly.management.upload.limit", 0x40000000L);
        try {
            ManagementHttpServer.Builder serverManagementBuilder = ManagementHttpServer.builder().setBindAddress(bindAddress).setSecureBindAddress(secureBindAddress).setModelController(modelController).setSSLContext(sslContext).setConsoleMode(this.consoleMode).setConsoleSlot(this.consoleSlot.get()).setChannelUpgradeHandler(upgradeHandler).setManagementHttpRequestProcessor(this.requestProcessorSupplier.get()).setAllowedOrigins(this.allowedOrigins).setWorker(this.workerSupplier.get()).setExecutor(this.executorSupplier.get()).setConstantHeaders(this.constantHeaders).setConsoleAvailability(consoleAvailability).setBacklog(this.backlog).setConnectionHighWater(this.connectionHighWater).setConnectionLowWater(this.connectionLowWater).setNoRequestTimeout(this.noRequestTimeout).setUploadLimit(uploadLimit);
            if (this.virtualSecurityDomainSupplier != null && this.virtualMechanismFactorySupplier != null) {
                SecurityDomain virtualSecurityDomain = this.virtualSecurityDomainSupplier.get();
                HttpServerAuthenticationMechanismFactory virtualMechanismFactory = this.virtualMechanismFactorySupplier.get();
                HttpAuthenticationFactory virtualHttpAuthenticationFactory = HttpAuthenticationFactory.builder().setFactory(virtualMechanismFactory).setSecurityDomain(virtualSecurityDomain).setMechanismConfigurationSelector(MechanismConfigurationSelector.constantSelector((MechanismConfiguration)MechanismConfiguration.EMPTY)).build();
                serverManagementBuilder.setHttpAuthenticationFactory(virtualHttpAuthenticationFactory);
            } else {
                serverManagementBuilder.setHttpAuthenticationFactory(httpAuthenticationFactory);
            }
            this.serverManagement = serverManagementBuilder.build();
            this.serverManagement.start();
            if (this.socketBindingManager != null) {
                if (this.useUnmanagedBindings) {
                    registry = this.socketBindingManager.getUnnamedRegistry();
                    if (bindAddress != null) {
                        boundAddress = (InetSocketAddress)this.serverManagement.getLocalAddress(InetSocketAddress.class);
                        this.basicManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-http", (InetSocketAddress)boundAddress, null);
                        registry.registerBinding(this.basicManagedBinding);
                    }
                    if (secureBindAddress != null) {
                        boundAddress = (InetSocketAddress)this.serverManagement.getSecureLocalAddress(InetSocketAddress.class);
                        this.secureManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)"management-https", (InetSocketAddress)boundAddress, null);
                        registry.registerBinding(this.secureManagedBinding);
                    }
                } else {
                    registry = this.socketBindingManager.getNamedRegistry();
                    if (basicBinding != null) {
                        boundAddress = (InetSocketAddress)this.serverManagement.getLocalAddress(InetSocketAddress.class);
                        this.basicManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)basicBinding.getName(), (InetSocketAddress)boundAddress, null);
                        registry.registerBinding(this.basicManagedBinding);
                    }
                    if (secureBinding != null) {
                        boundAddress = (InetSocketAddress)this.serverManagement.getSecureLocalAddress(InetSocketAddress.class);
                        this.secureManagedBinding = ManagedBinding.Factory.createSimpleManagedBinding((String)secureBinding.getName(), (InetSocketAddress)boundAddress, null);
                        registry.registerBinding(this.secureManagedBinding);
                    }
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof BindException || cause instanceof BindException) {
                StringBuilder sb = new StringBuilder().append(e.getLocalizedMessage());
                if (bindAddress != null) {
                    sb.append(" ").append(bindAddress);
                }
                if (secureBindAddress != null) {
                    sb.append(" ").append(secureBindAddress);
                }
                throw new StartException(sb.toString());
            }
            throw ServerLogger.ROOT_LOGGER.failedToStartHttpManagementService(e);
        }
        this.httpManagementConsumer.accept(this.httpManagement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        block9: {
            this.httpManagementConsumer.accept(null);
            ListenerRegistry lr = this.listenerRegistrySupplier.get();
            if (lr != null) {
                lr.removeListener(HTTP_MANAGEMENT);
                lr.removeListener(HTTPS_MANAGEMENT);
            }
            if (this.serverManagement != null) {
                SocketBindingManager.UnnamedBindingRegistry registry;
                try {
                    this.serverManagement.stop();
                    this.serverManagement = null;
                    if (this.socketBindingManager == null) break block9;
                    Object object = registry = this.useUnmanagedBindings ? this.socketBindingManager.getUnnamedRegistry() : this.socketBindingManager.getNamedRegistry();
                }
                catch (Throwable throwable) {
                    this.serverManagement = null;
                    if (this.socketBindingManager != null) {
                        SocketBindingManager.UnnamedBindingRegistry registry2;
                        Object object = registry2 = this.useUnmanagedBindings ? this.socketBindingManager.getUnnamedRegistry() : this.socketBindingManager.getNamedRegistry();
                        if (this.basicManagedBinding != null) {
                            registry2.unregisterBinding(this.basicManagedBinding);
                            this.basicManagedBinding = null;
                        }
                        if (this.secureManagedBinding != null) {
                            registry2.unregisterBinding(this.secureManagedBinding);
                            this.secureManagedBinding = null;
                        }
                        this.socketBindingManager = null;
                        this.useUnmanagedBindings = false;
                    }
                    throw throwable;
                }
                if (this.basicManagedBinding != null) {
                    registry.unregisterBinding(this.basicManagedBinding);
                    this.basicManagedBinding = null;
                }
                if (this.secureManagedBinding != null) {
                    registry.unregisterBinding(this.secureManagedBinding);
                    this.secureManagedBinding = null;
                }
                this.socketBindingManager = null;
                this.useUnmanagedBindings = false;
            }
        }
    }

    public HttpManagement getValue() throws IllegalStateException, IllegalArgumentException {
        return this.httpManagement;
    }
}

