/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ManifestClassPathProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleLoader;

public final class ModuleClassPathProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        List additionalModules;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        AttachmentList<String> entries = deploymentUnit.getAttachment(ManifestClassPathProcessor.CLASS_PATH_MODULES);
        if (entries != null) {
            for (String entry : entries) {
                moduleSpecification.addLocalDependency(ModuleDependency.Builder.of(moduleLoader, entry).setExport(true).setImportServices(true).build());
            }
        }
        if ((additionalModules = (List)deploymentUnit.getAttachment(Attachments.ADDITIONAL_MODULES)) != null) {
            for (AdditionalModuleSpecification additionalModule : additionalModules) {
                AttachmentList<String> dependencies = additionalModule.getAttachment(ManifestClassPathProcessor.CLASS_PATH_MODULES);
                if (dependencies == null || dependencies.isEmpty()) continue;
                for (String entry : dependencies) {
                    additionalModule.addLocalDependency(ModuleDependency.Builder.of(moduleLoader, entry).setExport(true).setImportServices(true).build());
                }
                additionalModule.addLocalDependency(ModuleDependency.Builder.of(moduleLoader, deploymentUnit.getAttachment(Attachments.MODULE_NAME)).setImportServices(true).build());
            }
        }
    }
}

