/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.embedded;

import java.util.List;
import java.util.concurrent.Future;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ElapsedTime;
import org.jboss.as.server.Main;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentWrapper;
import org.jboss.as.server.embedded.AbstractEmbeddedProcessBootstrap;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrap;
import org.wildfly.core.embedded.spi.EmbeddedProcessBootstrapConfiguration;

public final class StandaloneEmbeddedProcessBootstrap
extends AbstractEmbeddedProcessBootstrap {
    public EmbeddedProcessBootstrap.Type getType() {
        return EmbeddedProcessBootstrap.Type.STANDALONE_SERVER;
    }

    @Override
    protected Future<ServiceContainer> bootstrapEmbeddedProcess(ElapsedTime elapsedTime, EmbeddedProcessBootstrapConfiguration configuration, ServiceActivator ... extraServices) {
        ServerEnvironmentWrapper wrapper = Main.determineEnvironment(configuration.getCmdArgs(), configuration.getSystemProperties(), configuration.getSystemEnv(), ServerEnvironment.LaunchType.EMBEDDED, elapsedTime);
        ServerEnvironment serverEnvironment = wrapper.getServerEnvironment();
        if (serverEnvironment == null) {
            if (wrapper.getServerEnvironmentStatus() == ServerEnvironmentWrapper.ServerEnvironmentStatus.ERROR) {
                throw ServerLogger.ROOT_LOGGER.cannotCreateServerEnvironment();
            }
            return null;
        }
        Bootstrap bootstrap = Bootstrap.Factory.newInstance();
        try {
            Bootstrap.Configuration bootstrapConfiguration = new Bootstrap.Configuration(serverEnvironment);
            bootstrapConfiguration.setModuleLoader(configuration.getModuleLoader());
            return bootstrap.startup(bootstrapConfiguration, List.of(extraServices));
        }
        catch (Exception ex) {
            bootstrap.failed();
            throw ex;
        }
    }
}

