/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.vfs.VirtualFile;

public class DriverDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String SERVICE_FILE_NAME = "META-INF/services/java.sql.Driver";
    private static final String JTA = "jakarta.transaction.api";

    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (deploymentUnit.hasAttachment(Attachments.RESOURCE_ROOTS)) {
            List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
            for (ResourceRoot root : resourceRoots) {
                VirtualFile child = root.getRoot().getChild(SERVICE_FILE_NAME);
                if (!child.exists()) continue;
                moduleSpecification.addSystemDependency(ModuleDependency.Builder.of(moduleLoader, JTA).build());
                break;
            }
        }
    }
}

