/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ModuleResolvePhaseService
implements Service<ModuleResolvePhaseService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"module", "resolve", "phase"});
    private final String moduleIdentifier;
    private final Set<String> alreadyResolvedModules;
    private final int phaseNumber;
    private final Set<ModuleDefinition> moduleSpecs = Collections.synchronizedSet(new HashSet());

    private ModuleResolvePhaseService(String moduleIdentifier, Set<String> alreadyResolvedModules, int phaseNumber) {
        this.moduleIdentifier = moduleIdentifier;
        this.alreadyResolvedModules = alreadyResolvedModules;
        this.phaseNumber = phaseNumber;
    }

    public void start(StartContext startContext) throws StartException {
        HashSet<ModuleDependency> nextPhaseIdentifiers = new HashSet<ModuleDependency>();
        HashSet<String> nextAlreadySeen = new HashSet<String>(this.alreadyResolvedModules);
        for (ModuleDefinition spec : this.moduleSpecs) {
            if (spec == null) continue;
            for (ModuleDependency dep : spec.getDependencies()) {
                if (dep.isOptional() || !ServiceModuleLoader.isDynamicModule(dep.getDependencyModule()) || this.alreadyResolvedModules.contains(dep.getDependencyModule())) continue;
                nextAlreadySeen.add(dep.getDependencyModule());
                nextPhaseIdentifiers.add(dep);
            }
        }
        if (nextPhaseIdentifiers.isEmpty()) {
            ServiceModuleLoader.installModuleResolvedService(startContext.getChildTarget(), this.moduleIdentifier);
        } else {
            ModuleResolvePhaseService.installService(startContext.getChildTarget(), this.moduleIdentifier, this.phaseNumber + 1, nextPhaseIdentifiers, nextAlreadySeen);
        }
    }

    public static void installService(ServiceTarget serviceTarget, ModuleDefinition moduleDefinition) {
        String moduleIdentifier = moduleDefinition.getModuleIdentifier().toString();
        ModuleResolvePhaseService nextPhaseService = new ModuleResolvePhaseService(moduleIdentifier, Collections.singleton(moduleDefinition.getModuleIdentifier().toString()), 0);
        nextPhaseService.getModuleSpecs().add(moduleDefinition);
        ServiceBuilder builder = serviceTarget.addService(ModuleResolvePhaseService.moduleResolvePhaseServiceName(moduleIdentifier, 0), (Service)nextPhaseService);
        builder.install();
    }

    private static void installService(ServiceTarget serviceTarget, String moduleIdentifier, int phaseNumber, Set<ModuleDependency> nextPhaseIdentifiers, Set<String> nextAlreadySeen) {
        final ModuleResolvePhaseService nextPhaseService = new ModuleResolvePhaseService(moduleIdentifier, nextAlreadySeen, phaseNumber);
        ServiceBuilder builder = serviceTarget.addService(ModuleResolvePhaseService.moduleResolvePhaseServiceName(moduleIdentifier, phaseNumber), (Service)nextPhaseService);
        for (ModuleDependency module : nextPhaseIdentifiers) {
            builder.addDependency(ServiceModuleLoader.moduleSpecServiceName(module.getDependencyModule()), ModuleDefinition.class, (Injector)new Injector<ModuleDefinition>(){
                ModuleDefinition definition;

                public synchronized void inject(ModuleDefinition o) throws InjectionException {
                    nextPhaseService.getModuleSpecs().add(o);
                    this.definition = o;
                }

                public synchronized void uninject() {
                    nextPhaseService.getModuleSpecs().remove(this.definition);
                    this.definition = null;
                }
            });
        }
        builder.install();
    }

    public void stop(StopContext stopContext) {
    }

    public ModuleResolvePhaseService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Set<ModuleDefinition> getModuleSpecs() {
        return this.moduleSpecs;
    }

    @Deprecated(forRemoval=true)
    public static ServiceName moduleSpecServiceName(ModuleIdentifier identifier, int phase) {
        return ModuleResolvePhaseService.moduleResolvePhaseServiceName(identifier.toString(), phase);
    }

    private static ServiceName moduleResolvePhaseServiceName(String identifier, int phase) {
        if (!ServiceModuleLoader.isDynamicModule(identifier)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, "deployment.");
        }
        return SERVICE_NAME.append(new String[]{identifier}).append(new String[]{"" + phase});
    }
}

