/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitPhaseBuilder;
import org.jboss.as.server.deployment.DeploymentUnitPhaseService;
import org.jboss.as.server.deployment.FunctionalVoidService;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.ExceptionConsumer;

public abstract class AbstractDeploymentUnitService
implements Service<DeploymentUnit> {
    private static final String FIRST_PHASE_NAME = Phase.values()[0].name();
    final ImmutableManagementResourceRegistration registration;
    final ManagementResourceRegistration mutableRegistration;
    final Resource resource;
    final CapabilityServiceSupport capabilityServiceSupport;
    private final Consumer<DeploymentUnit> deploymentUnitConsumer;
    protected final String name;
    private volatile DeploymentUnitPhaseBuilder phaseBuilder = null;
    private volatile DeploymentUnit deploymentUnit;
    private volatile StabilityMonitor monitor;

    AbstractDeploymentUnitService(Consumer<DeploymentUnit> deploymentUnitConsumer, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, Resource resource, CapabilityServiceSupport capabilityServiceSupport, String name) {
        this.deploymentUnitConsumer = deploymentUnitConsumer;
        this.mutableRegistration = mutableRegistration;
        this.capabilityServiceSupport = capabilityServiceSupport;
        this.registration = registration;
        this.resource = resource;
        this.name = name;
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceTarget target = context.getChildTarget();
        this.monitor = new StabilityMonitor();
        this.monitor.addController(context.getController());
        this.deploymentUnit = this.createAndInitializeDeploymentUnit((ServiceRegistry)context.getController().getServiceContainer());
        String managementName = this.deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME);
        if (this.deploymentUnit.getParent() == null) {
            ServerLogger.DEPLOYMENT_LOGGER.startingDeployment(managementName, this.name);
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.startingSubDeployment(this.name);
        }
        ExceptionConsumer installer = startContext -> {
            ServiceName serviceName = this.deploymentUnit.getServiceName().append(new String[]{FIRST_PHASE_NAME});
            DeploymentUnitPhaseService<?> phaseService = DeploymentUnitPhaseService.create(this.deploymentUnit, Phase.values()[0]);
            startContext.getChildTarget().addService(serviceName, phaseService).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, phaseService.getDeployerChainsInjector()).install();
        };
        if (this.phaseBuilder != null) {
            this.deploymentUnit.putAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER, this.phaseBuilder);
            Set<AttachmentKey<?>> initialAttachmentKeys = this.getDeploymentUnitAttachmentKeys();
            Consumer<StopContext> uninstaller = stopContext -> {
                for (AttachmentKey<?> key : this.getDeploymentUnitAttachmentKeys()) {
                    if (initialAttachmentKeys.contains(key)) continue;
                    this.deploymentUnit.removeAttachment(key);
                }
            };
            ServiceName serviceName = this.deploymentUnit.getServiceName().append(new String[]{"installer"});
            this.phaseBuilder.build(target, serviceName, new FunctionalVoidService((ExceptionConsumer<StartContext, StartException>)installer, uninstaller)).install();
        } else {
            installer.accept((Object)context);
        }
        this.deploymentUnitConsumer.accept(this.deploymentUnit);
    }

    protected abstract DeploymentUnit createAndInitializeDeploymentUnit(ServiceRegistry var1);

    public synchronized void stop(StopContext context) {
        this.deploymentUnitConsumer.accept(null);
        String managementName = this.deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME);
        if (this.deploymentUnit.getParent() == null) {
            ServerLogger.DEPLOYMENT_LOGGER.stoppedDeployment(managementName, this.name, (int)(context.getElapsedTime() / 1000000L));
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.stoppedSubDeployment(this.name, (int)(context.getElapsedTime() / 1000000L));
        }
        this.phaseBuilder = this.deploymentUnit.getAttachment(Attachments.DEPLOYMENT_UNIT_PHASE_BUILDER);
        for (AttachmentKey<?> key : this.getDeploymentUnitAttachmentKeys()) {
            this.deploymentUnit.removeAttachment(key);
        }
        this.deploymentUnit = null;
        this.monitor.removeController(context.getController());
        this.monitor = null;
        DeploymentResourceSupport.cleanup(this.resource);
    }

    private Set<AttachmentKey<?>> getDeploymentUnitAttachmentKeys() {
        return ((SimpleAttachable)((Object)this.deploymentUnit)).attachmentKeys();
    }

    public synchronized DeploymentUnit getValue() throws IllegalStateException, IllegalArgumentException {
        return this.deploymentUnit;
    }

    public DeploymentStatus getStatus() {
        StabilityMonitor monitor = this.monitor;
        if (monitor == null) {
            return DeploymentStatus.STOPPED;
        }
        HashSet problems = new HashSet();
        try {
            monitor.awaitStability(problems, problems);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return problems.isEmpty() ? DeploymentStatus.OK : DeploymentStatus.FAILED;
    }

    public static enum DeploymentStatus {
        NEW,
        OK,
        FAILED,
        STOPPED;

    }
}

