/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.OperationListener;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class GracefulShutdownService
implements Service<GracefulShutdownService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "graceful-shutdown-service"});
    private final InjectedValue<SuspendController> suspendControllerInjectedValue = new InjectedValue();
    private boolean suspend = false;
    private boolean shuttingDown = false;
    private final Object lock = new Object();
    private final OperationListener listener = new OperationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void suspendStarted() {
            Object object = GracefulShutdownService.this.lock;
            synchronized (object) {
                GracefulShutdownService.this.suspend = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            Object object = GracefulShutdownService.this.lock;
            synchronized (object) {
                GracefulShutdownService.this.suspend = false;
                GracefulShutdownService.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelled() {
            Object object = GracefulShutdownService.this.lock;
            synchronized (object) {
                GracefulShutdownService.this.suspend = false;
                GracefulShutdownService.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeout() {
            Object object = GracefulShutdownService.this.lock;
            synchronized (object) {
                GracefulShutdownService.this.suspend = false;
                GracefulShutdownService.this.lock.notifyAll();
            }
        }
    };

    public void start(StartContext context) throws StartException {
        ((SuspendController)this.suspendControllerInjectedValue.getValue()).addListener(this.listener);
    }

    public void stop(StopContext context) {
        ((SuspendController)this.suspendControllerInjectedValue.getValue()).removeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startGracefulShutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.shuttingDown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitSuspend() {
        Object object = this.lock;
        synchronized (object) {
            while (this.suspend && this.shuttingDown) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    ServerLogger.AS_ROOT_LOGGER.debug("Exception waiting for graceful shutdown", e);
                }
            }
        }
    }

    public InjectedValue<SuspendController> getSuspendControllerInjectedValue() {
        return this.suspendControllerInjectedValue;
    }

    public GracefulShutdownService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

