/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.net.SocketBindingGroupResourceDefinition;
import org.jboss.as.server.services.net.SocketBindingManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;

public class BindingGroupAddHandler
extends AbstractAddStepHandler {
    public static final BindingGroupAddHandler INSTANCE = new BindingGroupAddHandler();

    public static ModelNode getOperation(PathAddress address, ModelNode model) {
        ModelNode op = Util.createAddOperation((PathAddress)address);
        op.get("default-interface").set(model.get("default-interface"));
        op.get("port-offset").set(model.get("port-offset"));
        return op;
    }

    private BindingGroupAddHandler() {
        super(new AttributeDefinition[]{SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE, SocketBindingGroupResourceDefinition.PORT_OFFSET});
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        resource.getModel().get("name").set(context.getCurrentAddressValue());
        final PathAddress mine = context.getCurrentAddress();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource root = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false);
                Set children = root.getChildren("socket-binding-group");
                if (children.size() > 1) {
                    for (Resource.ResourceEntry entry : children) {
                        if (entry.getName().equals(mine.getLastElement().getValue())) continue;
                        throw ServerLogger.ROOT_LOGGER.cannotAddMoreThanOneSocketBindingGroupForServerOrHost(mine, PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"socket-binding-group", (String)entry.getName())}));
                    }
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        int portOffset = SocketBindingGroupResourceDefinition.PORT_OFFSET.resolveModelAttribute(context, model).asInt();
        String defaultInterface = SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.resolveModelAttribute(context, model).asString();
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(SocketBindingGroupResourceDefinition.SOCKET_BINDING_MANAGER_CAPABILITY);
        Consumer sbmConsumer = builder.provides(new RuntimeCapability[]{SocketBindingGroupResourceDefinition.SOCKET_BINDING_MANAGER_CAPABILITY});
        Supplier nibSupplier = builder.requiresCapability("org.wildfly.network.interface", NetworkInterfaceBinding.class, new String[]{defaultInterface});
        builder.setInstance((Service)new SocketBindingManagerService(sbmConsumer, nibSupplier, portOffset));
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }
}

