/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.jboss.as.repository.PathUtil;
import org.jboss.as.server.controller.git.ElytronClientCredentialsProvider;
import org.jboss.as.server.controller.git.ElytronClientSshdSessionFactory;
import org.jboss.as.server.controller.git.GitRepositoryConfiguration;
import org.jboss.as.server.logging.ServerLogger;
import org.wildfly.client.config.ConfigXMLParseException;

public class GitRepository
implements Closeable {
    private final Set<String> ignored;
    private final Repository repository;
    private final Path basePath;
    private final String defaultRemoteRepository;
    private final String branch;
    private final SshdSessionFactory sshdSessionFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GitRepository(GitRepositoryConfiguration gitConfig) throws IllegalArgumentException, IOException, ConfigXMLParseException, GeneralSecurityException {
        block48: {
            File gitDir;
            File baseDir;
            block50: {
                this.basePath = gitConfig.getBasePath();
                this.branch = gitConfig.getBranch();
                this.ignored = gitConfig.getIgnored();
                this.defaultRemoteRepository = gitConfig.getRepository();
                baseDir = this.basePath.toFile();
                gitDir = new File(baseDir, ".git");
                if (gitConfig.getAuthenticationConfig() != null) {
                    CredentialsProvider.setDefault((CredentialsProvider)new ElytronClientCredentialsProvider(gitConfig.getAuthenticationConfig()));
                }
                this.sshdSessionFactory = new ElytronClientSshdSessionFactory(gitConfig.getAuthenticationConfig());
                SshSessionFactory.setInstance((SshSessionFactory)this.sshdSessionFactory);
                if (gitDir.exists()) {
                    try {
                        this.repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(baseDir)).setGitDir(gitDir)).setup()).build();
                    }
                    catch (IOException ex) {
                        throw ServerLogger.ROOT_LOGGER.failedToPullRepository(ex, gitConfig.getRepository());
                    }
                    try (Git git = Git.wrap((Repository)this.repository);){
                        git.clean();
                        if (!this.isLocalGitRepository(gitConfig.getRepository())) {
                            String remote = this.getRemoteName(gitConfig.getRepository());
                            this.checkoutToSelectedBranch(git);
                            PullResult result = git.pull().setRemote(remote).setRemoteBranchName(this.branch).setStrategy((MergeStrategy)MergeStrategy.RESOLVE).call();
                            if (!result.isSuccessful()) {
                                throw ServerLogger.ROOT_LOGGER.failedToPullRepository(null, gitConfig.getRepository());
                            }
                            break block48;
                        }
                        if (!this.branch.equals(this.repository.getBranch())) {
                            this.checkoutToSelectedBranch(git);
                        }
                        break block48;
                    }
                    catch (GitAPIException ex) {
                        throw ServerLogger.ROOT_LOGGER.failedToPullRepository((Exception)((Object)ex), gitConfig.getRepository());
                    }
                }
                if (this.isLocalGitRepository(gitConfig.getRepository())) {
                    try (Git git = Git.init().setDirectory(baseDir).setInitialBranch(this.branch).call();){
                        StoredConfig config = git.getRepository().getConfig();
                        config.setBoolean("commit", null, "gpgSign", gitConfig.isSign());
                        config.setBoolean("tag", null, "gpgSign", gitConfig.isSign());
                        config.save();
                        AddCommand addCommand = git.add();
                        addCommand.addFilepattern("data/content/");
                        Path configurationDir = this.basePath.resolve("configuration");
                        try (Stream<Path> files = Files.list(configurationDir);){
                            files.filter(configFile -> !"logging.properties".equals(configFile.getFileName().toString()) && Files.isRegularFile(configFile, new LinkOption[0])).forEach(configFile -> addCommand.addFilepattern(this.getPattern((Path)configFile)));
                        }
                        addCommand.call();
                        this.createGitIgnore(git, this.basePath);
                        git.commit().setSign(Boolean.valueOf(gitConfig.isSign())).setMessage(ServerLogger.ROOT_LOGGER.repositoryInitialized()).call();
                        break block50;
                    }
                    catch (IOException | GitAPIException ex) {
                        throw ServerLogger.ROOT_LOGGER.failedToInitRepository((Exception)ex, gitConfig.getRepository());
                    }
                }
                Path atticPath = this.basePath.getParent().resolve("attic");
                Files.copy(this.basePath, atticPath, StandardCopyOption.REPLACE_EXISTING);
                this.clearExistingFiles(this.basePath, gitConfig.getRepository());
                try (Git git = Git.init().setDirectory(baseDir).setInitialBranch(this.branch).call();){
                    String remoteName = UUID.randomUUID().toString();
                    StoredConfig config = git.getRepository().getConfig();
                    config.setString("remote", remoteName, "url", gitConfig.getRepository());
                    config.setString("remote", remoteName, "fetch", "+refs/heads/*:refs/remotes/" + remoteName + "/*");
                    config.setBoolean("commit", null, "gpgSign", gitConfig.isSign());
                    config.setBoolean("tag", null, "gpgSign", gitConfig.isSign());
                    config.save();
                    git.clean().call();
                    git.pull().setRemote(remoteName).setRemoteBranchName(this.branch).setStrategy((MergeStrategy)MergeStrategy.RESOLVE).call();
                    if (this.createGitIgnore(git, this.basePath)) {
                        git.commit().setMessage(ServerLogger.ROOT_LOGGER.addingIgnored()).call();
                    }
                }
                catch (GitAPIException ex) {
                    try (Stream<Path> names = Files.list(this.basePath);){
                        names.filter(p -> !"log".equals(p.getFileName().toString())).forEach(PathUtil::deleteSilentlyRecursively);
                    }
                    PathUtil.copyRecursively((Path)atticPath, (Path)this.basePath, (boolean)true);
                    throw ServerLogger.ROOT_LOGGER.failedToInitRepository((Exception)((Object)ex), gitConfig.getRepository());
                }
                finally {
                    PathUtil.deleteSilentlyRecursively((Path)atticPath);
                }
            }
            this.repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(baseDir)).setGitDir(gitDir)).setup()).build();
        }
        ServerLogger.ROOT_LOGGER.usingGit();
    }

    private void clearExistingFiles(Path root, String gitRepository) {
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!GitRepository.this.ignored.contains(dir.getFileName().toString() + "/")) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        ServerLogger.ROOT_LOGGER.debugf("Deleting file %s", file);
                        Files.delete(file);
                    }
                    catch (IOException ioex) {
                        ServerLogger.ROOT_LOGGER.debug(ioex.getMessage(), ioex);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    try {
                        ServerLogger.ROOT_LOGGER.debugf("Deleting file %s", dir);
                        Files.delete(dir);
                    }
                    catch (IOException ioex) {
                        ServerLogger.ROOT_LOGGER.debug(ioex.getMessage(), ioex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw ServerLogger.ROOT_LOGGER.failedToInitRepository(ex, gitRepository);
        }
    }

    public GitRepository(Repository repository) {
        this.repository = repository;
        this.ignored = Collections.emptySet();
        this.defaultRemoteRepository = "origin";
        this.branch = "master";
        this.basePath = repository.isBare() ? repository.getDirectory().toPath() : repository.getDirectory().toPath().getParent();
        ServerLogger.ROOT_LOGGER.usingGit();
        this.sshdSessionFactory = null;
    }

    private void checkoutToSelectedBranch(Git git) throws IOException, GitAPIException {
        Ref ref;
        boolean createBranch;
        boolean bl = createBranch = !ObjectId.isId((String)this.branch);
        if (createBranch && (ref = git.getRepository().exactRef("refs/heads/" + this.branch)) != null) {
            createBranch = false;
        }
        CheckoutCommand checkout = git.checkout().setCreateBranch(createBranch).setName(this.branch);
        checkout.call();
        if (checkout.getResult().getStatus() == CheckoutResult.Status.ERROR) {
            throw ServerLogger.ROOT_LOGGER.failedToPullRepository(null, this.defaultRemoteRepository);
        }
    }

    private boolean createGitIgnore(Git git, Path root) throws IOException, GitAPIException {
        Path gitIgnore = root.resolve(".gitignore");
        if (Files.notExists(gitIgnore, new LinkOption[0])) {
            Files.write(gitIgnore, this.ignored, new OpenOption[0]);
            git.add().addFilepattern(".gitignore").call();
            return true;
        }
        return false;
    }

    private boolean isLocalGitRepository(String gitRepository) {
        return "local".equals(gitRepository);
    }

    public Git getGit() {
        return Git.wrap((Repository)this.repository);
    }

    public File getDirectory() {
        return this.repository.getDirectory();
    }

    public boolean isBare() {
        return this.repository.isBare();
    }

    @Override
    public void close() {
        if (this.sshdSessionFactory != null) {
            this.sshdSessionFactory.close();
        }
        this.repository.close();
    }

    public String getPattern(File file) {
        return this.getPattern(file.toPath());
    }

    public String getPattern(Path file) {
        return this.basePath.toAbsolutePath().relativize(file.toAbsolutePath()).toString().replace('\\', '/');
    }

    public String getBranch() {
        return this.branch;
    }

    public final boolean isValidRemoteName(String remoteName) {
        return this.repository.getRemoteNames().contains(remoteName);
    }

    public final String getRemoteName(String gitRepository) {
        return this.findRemoteName(gitRepository == null || gitRepository.isEmpty() ? this.defaultRemoteRepository : gitRepository);
    }

    private String findRemoteName(String gitRepository) {
        if (this.isValidRemoteName(gitRepository)) {
            return gitRepository;
        }
        StoredConfig config = this.repository.getConfig();
        for (String remoteName : this.repository.getRemoteNames()) {
            if (!gitRepository.equals(config.getString("remote", remoteName, "url"))) continue;
            return remoteName;
        }
        return null;
    }

    public void rollback() throws GitAPIException {
        try (Git git = this.getGit();){
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
        }
    }

    public void commit(String msg) throws GitAPIException {
        try (Git git = this.getGit();){
            Status status = git.status().call();
            if (!status.isClean()) {
                git.commit().setMessage(msg).setAll(true).setNoVerify(true).call();
            }
        }
    }
}

