/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ExpressionResolverExtension;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class RuntimeExpressionResolver
extends ExpressionResolverImpl
implements ExpressionResolver.ResolverExtensionRegistry {
    private static final Logger log = Logger.getLogger(RuntimeExpressionResolver.class);
    private static final String EXPRESSION_RESOLVER_CAPABILITY = "org.wildfly.controller.expression-resolver";
    private final Set<ExpressionResolverExtension> extensions = new HashSet<ExpressionResolverExtension>();

    public synchronized void addResolverExtension(ExpressionResolverExtension extension) {
        this.extensions.add(extension);
    }

    public synchronized void removeResolverExtension(ExpressionResolverExtension extension) {
        this.extensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolvePluggableExpression(ModelNode node, OperationContext context) throws OperationFailedException {
        String expression = node.asString();
        if (context != null && expression.length() > 3) {
            String result = null;
            Set<ExpressionResolverExtension> set = this.extensions;
            synchronized (set) {
                Iterator<ExpressionResolverExtension> iter = this.extensions.iterator();
                while (result == null && iter.hasNext()) {
                    result = this.resolveExpression(expression, iter.next(), context);
                }
            }
            if (result == null && context.getCurrentStage() != OperationContext.Stage.MODEL) {
                ExpressionResolverExtension expressionResolver = null;
                try {
                    expressionResolver = (ExpressionResolverExtension)context.getCapabilityRuntimeAPI(EXPRESSION_RESOLVER_CAPABILITY, ExpressionResolverExtension.class);
                    result = expressionResolver.resolveExpression(expression, context);
                }
                catch (IllegalStateException ise) {
                    log.tracef("Not resolving %s -- runtime capability not available.", (Object)expression.substring(2, expression.length() - 1));
                }
                if (expressionResolver != null) {
                    result = this.resolveExpression(expression, expressionResolver, context);
                }
            }
            if (result != null) {
                node.set(result);
            }
        }
    }

    private String resolveExpression(String expression, ExpressionResolverExtension resolver, OperationContext context) throws OperationFailedException {
        resolver.initialize(context);
        return resolver.resolveExpression(expression, context);
    }
}

