/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.security;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;

public class VirtualDomainMarkerUtility {
    private static final AttachmentKey<Boolean> REQUIRED = AttachmentKey.create(Boolean.class);
    private static final ServiceName DOMAIN_SUFFIX = ServiceName.of((String[])new String[]{"security-domain", "virtual"});

    public static void virtualDomainRequired(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualDomainMarkerUtility.toRoot(deploymentUnit);
        rootUnit.putAttachment(REQUIRED, Boolean.TRUE);
    }

    public static boolean isVirtualDomainRequired(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualDomainMarkerUtility.toRoot(deploymentUnit);
        Boolean required = rootUnit.getAttachment(REQUIRED);
        return required == null ? false : required;
    }

    public static ServiceName virtualDomainName(DeploymentUnit deploymentUnit) {
        DeploymentUnit rootUnit = VirtualDomainMarkerUtility.toRoot(deploymentUnit);
        return rootUnit.getServiceName().append(DOMAIN_SUFFIX);
    }

    private static DeploymentUnit toRoot(DeploymentUnit deploymentUnit) {
        DeploymentUnit result = deploymentUnit;
        DeploymentUnit parent = result.getParent();
        while (parent != null) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }
}

