/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleIndexBuilder;
import org.jboss.jandex.Indexer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.wildfly.common.Assert;

public final class AnnotationIndexSupport {
    private final ConcurrentMap<String, Lock> indexLocks = new ConcurrentHashMap<String, Lock>();
    private final Map<String, CompositeIndex> indexCache = new ConcurrentHashMap<String, CompositeIndex>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompositeIndex getAnnotationIndices(String moduleId, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        Assert.checkNotNullParam((String)"moduleId", (Object)moduleId);
        Assert.checkNotNullParam((String)"moduleLoader", (Object)moduleLoader);
        CompositeIndex result = this.indexCache.get(moduleId);
        if (result == null) {
            Lock lock = this.getModuleIndexLock(moduleId);
            try {
                lock.lockInterruptibly();
                try {
                    result = this.indexCache.get(moduleId);
                    if (result != null) return result;
                    result = AnnotationIndexSupport.indexModule(moduleId, moduleLoader);
                    this.indexCache.put(moduleId, result);
                    return result;
                }
                finally {
                    lock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                result = this.indexCache.get(moduleId);
                if (result != null) return result;
                throw ServerLogger.DEPLOYMENT_LOGGER.staticModuleIndexingFailed(moduleId, e);
            }
        } else {
            ServerLogger.DEPLOYMENT_LOGGER.debugf("Using cached annotation indices for static module %s", moduleId);
        }
        return result;
    }

    private Lock getModuleIndexLock(String moduleId) {
        Lock lock = (Lock)this.indexLocks.get(moduleId);
        if (lock == null) {
            lock = new ReentrantLock();
            Lock existing = this.indexLocks.putIfAbsent(moduleId, lock);
            lock = existing == null ? lock : existing;
        }
        return lock;
    }

    static CompositeIndex indexModule(String moduleIdentifier, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        ServerLogger.DEPLOYMENT_LOGGER.debugf("Creating annotation index for static module %s", moduleIdentifier);
        try {
            Module module = moduleLoader.loadModule(moduleIdentifier);
            CompositeIndex additionalIndex = ModuleIndexBuilder.buildCompositeIndex(module);
            CompositeIndex result = additionalIndex != null ? additionalIndex : AnnotationIndexSupport.calculateModuleIndex(module);
            return result;
        }
        catch (IOException | ModuleLoadException e) {
            throw ServerLogger.DEPLOYMENT_LOGGER.staticModuleIndexingFailed(moduleIdentifier, e);
        }
    }

    private static CompositeIndex calculateModuleIndex(Module module) throws ModuleLoadException, IOException {
        Indexer indexer = new Indexer();
        PathFilter filter = PathFilters.getDefaultImportFilter();
        Iterator iterator = module.iterateResources(filter);
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.getName().endsWith(".class")) continue;
            try {
                InputStream in = resource.openStream();
                Throwable throwable = null;
                try {
                    indexer.index(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                ServerLogger.DEPLOYMENT_LOGGER.cannotIndexClass(resource.getName(), resource.getURL().toExternalForm(), e);
            }
        }
        return new CompositeIndex(Collections.singleton(indexer.complete()));
    }
}

