/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironmentSystemPropertyUpdater;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.controller.resources.SystemPropertyResourceDefinition;
import org.jboss.as.server.operations.SystemPropertyDeferredProcessor;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SystemPropertyAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    private final ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater;
    private final AttributeDefinition[] attributes;

    public static ModelNode getOperation(ModelNode address, String value) {
        return SystemPropertyAddHandler.getOperation(address, value, null);
    }

    public static ModelNode getOperation(ModelNode address, String value, Boolean boottime) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        if (value == null) {
            op.get(SystemPropertyResourceDefinition.VALUE.getName()).set(new ModelNode());
        } else {
            op.get(SystemPropertyResourceDefinition.VALUE.getName()).set(value);
        }
        if (boottime != null) {
            op.get(SystemPropertyResourceDefinition.BOOT_TIME.getName()).set(boottime.booleanValue());
        }
        return op;
    }

    public SystemPropertyAddHandler(ProcessEnvironmentSystemPropertyUpdater systemPropertyUpdater, AttributeDefinition[] attributes) {
        this.systemPropertyUpdater = systemPropertyUpdater;
        this.attributes = attributes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean reload;
        ModelNode model = context.createResource(PathAddress.EMPTY_ADDRESS).getModel();
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
        final String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        String value = operation.hasDefined(SystemPropertyResourceDefinition.VALUE.getName()) ? operation.get(SystemPropertyResourceDefinition.VALUE.getName()).asString() : null;
        boolean applyToRuntime = this.systemPropertyUpdater != null && this.systemPropertyUpdater.isRuntimeSystemPropertyUpdateAllowed(name, value, context.isBooting());
        boolean bl = reload = !applyToRuntime && context.getProcessType().isServer();
        if (applyToRuntime) {
            String setValue = null;
            boolean setIt = false;
            try {
                setValue = value != null ? SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(context, model).asString() : null;
                setIt = true;
            }
            catch (Exception resolutionFailure) {
                this.handleResolutionFailure(context, model, name, resolutionFailure);
            }
            if (setIt) {
                this.setProperty(name, setValue);
            }
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
                if (SystemPropertyAddHandler.this.systemPropertyUpdater != null) {
                    WildFlySecurityManager.clearPropertyPrivileged((String)name);
                    if (SystemPropertyAddHandler.this.systemPropertyUpdater != null) {
                        SystemPropertyAddHandler.this.systemPropertyUpdater.systemPropertyUpdated(name, null);
                    }
                }
            }
        });
    }

    private void setProperty(String name, String value) {
        if (value != null) {
            WildFlySecurityManager.setPropertyPrivileged((String)name, (String)value);
        } else {
            WildFlySecurityManager.clearPropertyPrivileged((String)name);
        }
        if (this.systemPropertyUpdater != null) {
            this.systemPropertyUpdater.systemPropertyUpdated(name, value);
        }
    }

    private void handleResolutionFailure(OperationContext context, ModelNode model, final String propertyName, final Exception resolutionFailure) {
        assert (resolutionFailure instanceof RuntimeException || resolutionFailure instanceof OperationFailedException) : "invalid resolutionFailure type " + resolutionFailure.getClass();
        DeferredProcessor deferredResolver = (DeferredProcessor)context.getAttachment(SystemPropertyDeferredProcessor.ATTACHMENT_KEY);
        if (deferredResolver == null) {
            deferredResolver = new DeferredProcessor();
            context.attach(SystemPropertyDeferredProcessor.ATTACHMENT_KEY, (Object)deferredResolver);
        }
        deferredResolver.unresolved.put(propertyName, model);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                DeferredProcessor deferredResolver = (DeferredProcessor)context.getAttachment(SystemPropertyDeferredProcessor.ATTACHMENT_KEY);
                if (deferredResolver != null && deferredResolver.unresolved.containsKey(propertyName)) {
                    context.setRollbackOnly();
                    if (resolutionFailure instanceof RuntimeException) {
                        throw (RuntimeException)resolutionFailure;
                    }
                    if (resolutionFailure instanceof OperationFailedException) {
                        throw (OperationFailedException)((Object)resolutionFailure);
                    }
                    throw new RuntimeException(resolutionFailure);
                }
            }
        }, OperationContext.Stage.VERIFY);
    }

    private class DeferredProcessor
    implements SystemPropertyDeferredProcessor {
        private final Map<String, ModelNode> unresolved = new HashMap<String, ModelNode>();

        private DeferredProcessor() {
        }

        @Override
        public void processDeferredProperties(OperationContext context) throws OperationFailedException {
            Iterator<Map.Entry<String, ModelNode>> it = this.unresolved.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ModelNode> entry = it.next();
                try {
                    String setValue = SystemPropertyResourceDefinition.VALUE.resolveModelAttribute(context, entry.getValue()).asString();
                    SystemPropertyAddHandler.this.setProperty(entry.getKey(), setValue);
                    it.remove();
                }
                catch (OperationFailedException resolutionFailure) {
                    context.setRollbackOnly();
                    throw resolutionFailure;
                }
                catch (RuntimeException resolutionFailure) {
                    context.setRollbackOnly();
                    throw resolutionFailure;
                }
            }
        }
    }
}

