/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.VFSUtils;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExternalModuleSpecService
implements Service<ModuleDefinition> {
    public static final int MAX_NUMBER_OF_JAR_RESOURCES = Integer.parseInt(WildFlySecurityManager.getPropertyPrivileged((String)"org.jboss.as.server.max_number_of_jar_resources", (String)"256"));
    private static final Logger log = Logger.getLogger(ExternalModuleSpecService.class);
    private static final List<String> EE_API_MODULES = Arrays.asList("javax.activation.api", "javax.annotation.api", "javax.batch.api", "javax.ejb.api", "javax.enterprise.api", "javax.enterprise.concurrent.api", "javax.inject.api", "javax.interceptor.api", "javax.json.api", "javax.jms.api", "javax.jws.api", "javax.mail.api", "javax.management.j2ee.api", "javax.persistence.api", "javax.resource.api", "javax.rmi.api", "javax.security.auth.message.api", "javax.security.jacc.api", "javax.servlet.api", "javax.servlet.jsp.api", "javax.transaction.api", "javax.validation.api", "javax.ws.rs.api", "javax.websocket.api", "javax.xml.bind.api", "javax.xml.soap.api", "javax.xml.ws.api", "org.glassfish.jakarta.el", "javax.xml.rpc.api", "org.omg.api", "javax.api");
    private final ModuleIdentifier moduleIdentifier;
    private final File file;
    private volatile ModuleDefinition moduleDefinition;
    private List<JarFile> jarFiles;

    public ExternalModuleSpecService(ModuleIdentifier moduleIdentifier, File file) {
        this.moduleIdentifier = moduleIdentifier;
        this.file = file;
        this.jarFiles = new ArrayList<JarFile>();
    }

    public synchronized void start(StartContext context) throws StartException {
        ModuleSpec.Builder specBuilder;
        block18: {
            String currentName = "";
            try {
                if (!this.file.isDirectory()) {
                    currentName = this.file.toString();
                    this.jarFiles.add(new JarFile(this.file));
                    specBuilder = ModuleSpec.build((String)this.moduleIdentifier.toString());
                    ExternalModuleSpecService.addResourceRoot(specBuilder, this.jarFiles.get(0));
                    log.debugf("Added %s jar file as resource root for %s module identifier", (Object)this.file.getAbsolutePath(), (Object)this.moduleIdentifier.getName());
                    break block18;
                }
                specBuilder = ModuleSpec.build((String)this.moduleIdentifier.toString());
                Path rootPath = this.file.toPath();
                ExternalModuleSpecService.addPathResourceRoot(specBuilder, rootPath);
                log.debugf("Added %s directory as resource root for %s module identifier", (Object)this.file.getAbsolutePath(), (Object)this.moduleIdentifier.getName());
                ArrayList processedPaths = new ArrayList();
                Stream<Path> pathStream = Files.walk(rootPath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar"));
                Object object = null;
                try {
                    pathStream.forEach(p -> {
                        processedPaths.add(p);
                        if (processedPaths.size() > MAX_NUMBER_OF_JAR_RESOURCES) {
                            throw new RuntimeException(ServerLogger.ROOT_LOGGER.maximumNumberOfJarResources(specBuilder.getName(), MAX_NUMBER_OF_JAR_RESOURCES));
                        }
                    });
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (pathStream != null) {
                        if (object != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            pathStream.close();
                        }
                    }
                }
                if (!processedPaths.isEmpty()) {
                    TreeSet jars = new TreeSet(processedPaths);
                    for (Path jar : jars) {
                        currentName = jar.toString();
                        JarFile jarFile = new JarFile(jar.toFile());
                        this.jarFiles.add(jarFile);
                        ExternalModuleSpecService.addResourceRoot(specBuilder, jarFile);
                        log.debugf("Added %s jar file as resource root for %s module identifier", (Object)jar.toString(), (Object)this.moduleIdentifier.getName());
                    }
                }
            }
            catch (IOException e) {
                throw ServerLogger.ROOT_LOGGER.errorOpeningZipFile(currentName, e);
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
        }
        ExternalModuleSpecService.addEEDependencies(specBuilder);
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
        ModuleSpec moduleSpec = specBuilder.create();
        this.moduleDefinition = new ModuleDefinition(this.moduleIdentifier, Collections.emptySet(), moduleSpec);
        ServiceModuleLoader.installModuleResolvedService(context.getChildTarget(), this.moduleIdentifier);
    }

    public synchronized void stop(StopContext context) {
        for (JarFile jarFile : this.jarFiles) {
            log.debugf("Closing %s jar file which was added as resource root for %s module identifier", (Object)jarFile.getName(), (Object)this.moduleIdentifier.getName());
            VFSUtils.safeClose((ZipFile)jarFile);
        }
        this.jarFiles.clear();
        this.jarFiles = null;
        this.moduleDefinition = null;
    }

    public ModuleDefinition getValue() throws IllegalStateException, IllegalArgumentException {
        return this.moduleDefinition;
    }

    private static void addResourceRoot(ModuleSpec.Builder specBuilder, JarFile file) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((JarFile)file)));
    }

    private static void addPathResourceRoot(ModuleSpec.Builder specBuilder, Path path) {
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createPathResourceLoader((Path)path)));
    }

    private static void addEEDependencies(ModuleSpec.Builder specBuilder) {
        for (String api : EE_API_MODULES) {
            ModuleDependencySpec dependencySpec = new ModuleDependencySpecBuilder().setName(api).setOptional(true).build();
            specBuilder.addDependency((DependencySpec)dependencySpec);
        }
    }
}

