/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.List;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ExplodedDeploymentMarker;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.SubDeploymentUnitService;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class SubDeploymentProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentResourceRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentResourceRoot.getRoot().isDirectory()) {
            ExplodedDeploymentMarker.markAsExplodedDeployment(deploymentUnit);
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        List<ResourceRoot> childRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot childRoot : childRoots) {
            if (childRoot == deploymentResourceRoot || !SubDeploymentMarker.isSubDeployment(childRoot)) continue;
            Resource resource = DeploymentResourceSupport.getOrCreateSubDeployment(childRoot.getRootName(), deploymentUnit);
            ImmutableManagementResourceRegistration registration = deploymentUnit.getAttachment(DeploymentResourceSupport.REGISTRATION_ATTACHMENT);
            ManagementResourceRegistration mutableRegistration = deploymentUnit.getAttachment(DeploymentResourceSupport.MUTABLE_REGISTRATION_ATTACHMENT);
            AbstractVaultReader vaultReader = deploymentUnit.getAttachment(Attachments.VAULT_READER_ATTACHMENT_KEY);
            PathManager pathManager = deploymentUnit.getAttachment(Attachments.PATH_MANAGER);
            SubDeploymentUnitService service = new SubDeploymentUnitService(childRoot, deploymentUnit, registration, mutableRegistration, resource, vaultReader, pathManager);
            ServiceName serviceName = Services.deploymentUnitName(deploymentUnit.getName(), childRoot.getRootName());
            serviceTarget.addService(serviceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            phaseContext.addDeploymentDependency(serviceName, Attachments.SUB_DEPLOYMENTS);
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, serviceName.append(ServiceName.of((String[])new String[]{Phase.STRUCTURE.name()})));
        }
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        ServiceRegistry serviceRegistry = deploymentUnit.getServiceRegistry();
        List<ResourceRoot> childRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot childRoot : childRoots) {
            ServiceName serviceName;
            ServiceController serviceController;
            if (!SubDeploymentMarker.isSubDeployment(childRoot) || (serviceController = serviceRegistry.getService(serviceName = Services.deploymentUnitName(deploymentUnit.getName(), childRoot.getRootName()))) == null) continue;
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }
}

