/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class BindingMetricHandlers {
    private static final ServiceName SOCKET_BINDING = SocketBinding.JBOSS_BINDING_NAME;

    private BindingMetricHandlers() {
    }

    public static class BoundPortHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound-port";
        public static final AttributeDefinition ATTRIBUTE_DEFINITION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("bound-port", ModelType.INT, true).setValidator((ParameterValidator)new IntRangeValidator(1, Integer.MAX_VALUE, true, false))).build();
        public static final OperationStepHandler INSTANCE = new BoundPortHandler();

        private BoundPortHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                int port = managedBinding.getBindAddress().getPort();
                result.set(port);
            }
        }

        @Override
        ModelNode getNoMetrics() {
            return new ModelNode();
        }
    }

    public static class BoundAddressHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound-address";
        public static final AttributeDefinition ATTRIBUTE_DEFINITION = new SimpleAttributeDefinition("bound-address", ModelType.STRING, true);
        public static final OperationStepHandler INSTANCE = new BoundAddressHandler();

        private BoundAddressHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            ManagedBinding managedBinding = binding.getManagedBinding();
            if (managedBinding != null) {
                InetAddress addr = managedBinding.getBindAddress().getAddress();
                result.set(NetworkUtils.canonize((String)addr.getHostAddress()));
            }
        }

        @Override
        ModelNode getNoMetrics() {
            return new ModelNode();
        }
    }

    public static class BoundHandler
    extends AbstractBindingMetricsHandler {
        public static final String ATTRIBUTE_NAME = "bound";
        public static final AttributeDefinition ATTRIBUTE_DEFINITION = new SimpleAttributeDefinition("bound", ModelType.BOOLEAN, true);
        public static final OperationStepHandler INSTANCE = new BoundHandler();

        private BoundHandler() {
        }

        @Override
        void execute(ModelNode operation, SocketBinding binding, ModelNode result) {
            result.set(binding.isBound());
        }

        @Override
        ModelNode getNoMetrics() {
            return new ModelNode().set(false);
        }
    }

    static abstract class AbstractBindingMetricsHandler
    implements OperationStepHandler {
        AbstractBindingMetricsHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            final PathElement element = address.getLastElement();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode result = context.getResult();
                    ServiceController controller = context.getServiceRegistry(false).getRequiredService(SOCKET_BINDING.append(new String[]{element.getValue()}));
                    if (controller != null && controller.getState() == ServiceController.State.UP) {
                        SocketBinding binding = (SocketBinding)SocketBinding.class.cast(controller.getValue());
                        AbstractBindingMetricsHandler.this.execute(operation, binding, result);
                    } else {
                        result.set(AbstractBindingMetricsHandler.this.getNoMetrics());
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }

        abstract void execute(ModelNode var1, SocketBinding var2, ModelNode var3);

        abstract ModelNode getNoMetrics();
    }
}

