/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class DumpServicesHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "dump-services";
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("dump-services", ServerDescriptions.getResourceDescriptionResolver(new String[0])).setRuntimeOnly().setReplyType(ModelType.STRING).build();
    public static final DumpServicesHandler INSTANCE = new DumpServicesHandler();

    private DumpServicesHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController service = context.getServiceRegistry(false).getRequiredService(Services.JBOSS_AS);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream print = new PrintStream(out);
                service.getServiceContainer().dumpServices(print);
                print.flush();
                context.getResult().set(new String(out.toByteArray()));
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

