/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.shutdown;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.shutdown.OperationListener;
import org.jboss.as.server.shutdown.ServerActivity;
import org.jboss.as.server.shutdown.ServerActivityListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class SuspendController
implements Service<SuspendController> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "suspend-controller"});
    private Timer timer;
    private State state = State.RUNNING;
    private final List<ServerActivity> activities = new ArrayList<ServerActivity>();
    private final List<OperationListener> operationListeners = new ArrayList<OperationListener>();
    private int outstandingCount;
    private final ServerActivityListener listener = new ServerActivityListener(){

        @Override
        public void requestsComplete() {
            SuspendController.this.activityPaused();
        }

        @Override
        public void unPaused() {
            SuspendController.this.activityResumed();
        }
    };

    public synchronized void suspend(long timeoutMillis) {
        ServerLogger.ROOT_LOGGER.suspendingServer();
        this.state = State.PAUSING;
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.suspendStarted();
        }
        this.outstandingCount = this.activities.size();
        if (this.outstandingCount == 0) {
            this.handlePause();
        } else {
            for (ServerActivity activity : this.activities) {
                activity.pause(this.listener);
            }
            this.timer = new Timer();
            if (timeoutMillis > 0L) {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SuspendController.this.timeout();
                    }
                }, timeoutMillis);
            }
        }
    }

    public synchronized void resume() {
        if (this.state == State.RUNNING) {
            return;
        }
        ServerLogger.ROOT_LOGGER.resumingServer();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.cancelled();
        }
        for (ServerActivity activity : this.activities) {
            activity.resume();
        }
        this.state = State.RUNNING;
    }

    public synchronized void registerActivity(ServerActivity activity) {
        this.activities.add(activity);
    }

    public synchronized void unRegisterActivity(ServerActivity activity) {
        this.activities.remove(activity);
    }

    public synchronized void start(StartContext startContext) throws StartException {
        this.state = State.RUNNING;
    }

    public synchronized void stop(StopContext stopContext) {
    }

    synchronized void activityPaused() {
        --this.outstandingCount;
        this.handlePause();
    }

    private void handlePause() {
        this.state = State.PAUSED;
        if (this.outstandingCount == 0) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
                listener.complete();
            }
        }
    }

    private synchronized void activityResumed() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.cancelled();
        }
    }

    synchronized void timeout() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        for (OperationListener listener : new ArrayList<OperationListener>(this.operationListeners)) {
            listener.timeout();
        }
    }

    public synchronized void addListener(OperationListener listener) {
        this.operationListeners.add(listener);
    }

    public synchronized void removeListener(OperationListener listener) {
        this.operationListeners.remove(listener);
    }

    public SuspendController getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static enum State {
        RUNNING,
        PAUSING,
        PAUSED;

    }
}

