/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.jboss.as.process.protocol.StreamUtils;
import org.jboss.as.process.stdin.Base64InputStream;
import org.jboss.as.server.GracefulShutdownService;
import org.jboss.as.server.ServerTask;
import org.jboss.as.server.mgmt.domain.HostControllerClient;
import org.jboss.as.server.mgmt.domain.HostControllerConnectionService;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.stdio.LoggingOutputStream;
import org.jboss.stdio.NullInputStream;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.jboss.threads.AsyncFuture;

public final class DomainServerMain {
    private DomainServerMain() {
    }

    public static void main(String[] args) {
        AsyncFuture<ServiceContainer> containerFuture;
        Base64InputStream initialInput = new Base64InputStream(System.in);
        PrintStream initialError = System.err;
        try {
            Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        StdioContext.install();
        StdioContext context = StdioContext.create((InputStream)new NullInputStream(), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stdout"), (java.util.logging.Level)Level.INFO), (OutputStream)new LoggingOutputStream((java.util.logging.Logger)Logger.getLogger((String)"stderr"), (java.util.logging.Level)Level.ERROR));
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(context));
        byte[] authKey = new byte[16];
        try {
            StreamUtils.readFully((InputStream)initialInput, (byte[])authKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
            throw new IllegalStateException();
        }
        MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)DomainServerMain.class.getClassLoader());
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            MarshallingConfiguration configuration = new MarshallingConfiguration();
            configuration.setVersion(2);
            configuration.setClassResolver((ClassResolver)new SimpleClassResolver(DomainServerMain.class.getClassLoader()));
            Unmarshaller unmarshaller = factory.createUnmarshaller(configuration);
            ByteInput byteInput = Marshalling.createByteInput((InputStream)initialInput);
            unmarshaller.start(byteInput);
            ServerTask task = (ServerTask)unmarshaller.readObject(ServerTask.class);
            unmarshaller.finish();
            containerFuture = task.run(Arrays.asList(new ServiceActivator(){

                public void activate(ServiceActivatorContext serviceActivatorContext) {
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace(initialError);
            System.exit(1);
            throw new IllegalStateException();
        }
        while (true) {
            try {
                while (true) {
                    String hostName = StreamUtils.readUTFZBytes((InputStream)initialInput);
                    int port = StreamUtils.readInt((InputStream)initialInput);
                    boolean managementSubsystemEndpoint = StreamUtils.readBoolean((InputStream)initialInput);
                    byte[] asAuthKey = new byte[16];
                    StreamUtils.readFully((InputStream)initialInput, (byte[])asAuthKey);
                    ServiceContainer container = (ServiceContainer)containerFuture.get();
                    HostControllerClient client = DomainServerMain.getRequiredService(container, HostControllerConnectionService.SERVICE_NAME, HostControllerClient.class);
                    client.reconnect(hostName, port, asAuthKey, managementSubsystemEndpoint);
                }
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                continue;
            }
            catch (EOFException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        try {
            ServiceContainer container = (ServiceContainer)containerFuture.get();
            GracefulShutdownService client = DomainServerMain.getRequiredService(container, GracefulShutdownService.SERVICE_NAME, GracefulShutdownService.class);
            client.awaitSuspend();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
        throw new IllegalStateException();
    }

    static <T> T getRequiredService(ServiceContainer container, ServiceName serviceName, Class<T> type) {
        ServiceController controller = container.getRequiredService(serviceName);
        return type.cast(controller.getValue());
    }
}

