/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Arrays;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.mgmt.NativeManagementResourceDefinition;
import org.jboss.as.server.operations.NativeManagementServices;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.OptionMap;

public class NativeManagementAddHandler
extends AbstractAddStepHandler {
    public static final NativeManagementAddHandler INSTANCE = new NativeManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition definition : NativeManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            NativeManagementAddHandler.validateAndSet(definition, operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName endpointName = ManagementRemotingServices.MANAGEMENT_ENDPOINT;
        String hostName = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.node.name", null);
        NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostName, context.getServiceRegistry(false));
        NativeManagementAddHandler.installNativeManagementConnector(context, model, endpointName, serviceTarget);
    }

    private static void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw ServerLogger.ROOT_LOGGER.attributeIsRequired(attributeName);
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw ServerLogger.ROOT_LOGGER.attributeNotAllowedWhenAlternativeIsPresent(attributeName, Arrays.asList(definition.getAlternatives()));
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }

    private static ModelNode validateResolvedModel(AttributeDefinition definition, OperationContext context, ModelNode subModel) throws OperationFailedException {
        ModelNode result;
        String attributeName = definition.getName();
        boolean has = subModel.has(attributeName);
        if (!has && definition.isRequired(subModel)) {
            throw ServerLogger.ROOT_LOGGER.attributeIsRequired(attributeName);
        }
        if (has) {
            if (!definition.isAllowed(subModel)) {
                if (subModel.hasDefined(attributeName)) {
                    throw ServerLogger.ROOT_LOGGER.attributeNotAllowedWhenAlternativeIsPresent(attributeName, Arrays.asList(definition.getAlternatives()));
                }
                result = new ModelNode();
            } else {
                result = definition.resolveModelAttribute(context, subModel);
            }
        } else {
            result = new ModelNode();
        }
        return result;
    }

    static void installNativeManagementConnector(OperationContext context, ModelNode model, ServiceName endpointName, ServiceTarget serviceTarget) throws OperationFailedException {
        ServiceName socketBindingServiceName = null;
        ServiceName interfaceSvcName = null;
        int port = 0;
        ModelNode socketBindingNode = NativeManagementAddHandler.validateResolvedModel((AttributeDefinition)NativeManagementResourceDefinition.SOCKET_BINDING, context, model);
        if (socketBindingNode.isDefined()) {
            String bindingName = NativeManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
            socketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
        } else {
            String interfaceName = NativeManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString();
            interfaceSvcName = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName});
            port = NativeManagementResourceDefinition.NATIVE_PORT.resolveModelAttribute(context, model).asInt();
        }
        String securityRealm = null;
        ModelNode realmNode = NativeManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        if (realmNode.isDefined()) {
            securityRealm = realmNode.asString();
        } else {
            ServerLogger.ROOT_LOGGER.nativeManagementInterfaceIsUnsecured();
        }
        ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.server.temp.dir"});
        RemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"management", (String)securityRealm, null, (ServiceName)tmpDirPath);
        OptionMap options = NativeManagementAddHandler.createConnectorOptions(context, model);
        if (socketBindingServiceName == null) {
            ManagementRemotingServices.installConnectorServicesForNetworkInterfaceBinding((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)"management", (ServiceName)interfaceSvcName, (int)port, (OptionMap)options);
        } else {
            ManagementRemotingServices.installConnectorServicesForSocketBinding((ServiceTarget)serviceTarget, (ServiceName)endpointName, (String)"management", (ServiceName)socketBindingServiceName, (OptionMap)options);
        }
    }

    private static OptionMap createConnectorOptions(OperationContext context, ModelNode model) throws OperationFailedException {
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)NativeManagementResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        ModelNode serverName = NativeManagementResourceDefinition.SERVER_NAME.resolveModelAttribute(context, model);
        if (serverName.isDefined()) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName.asString());
        }
        return builder.getMap();
    }
}

