/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.server.deployment.DeployerChainsService;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.RegisteredDeploymentUnitProcessor;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeployerChainAddHandler
implements OperationStepHandler {
    static final String NAME = "add-deployer-chains";
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("add-deployer-chains", ControllerResolver.getResolver((String[])new String[0])).setPrivateEntry().build();
    public static final DeployerChainAddHandler INSTANCE = new DeployerChainAddHandler();
    static ModelNode OPERATION = new ModelNode();
    private final EnumMap<Phase, Set<RegisteredDeploymentUnitProcessor>> deployerMap;

    public static void addDeploymentProcessor(String subsystemName, Phase phase, int priority, DeploymentUnitProcessor processor) {
        RegisteredDeploymentUnitProcessor registeredDeploymentUnitProcessor;
        EnumMap<Phase, Set<RegisteredDeploymentUnitProcessor>> deployerMap = DeployerChainAddHandler.INSTANCE.deployerMap;
        Set<RegisteredDeploymentUnitProcessor> registeredDeploymentUnitProcessors = deployerMap.get((Object)phase);
        if (registeredDeploymentUnitProcessors.contains(registeredDeploymentUnitProcessor = new RegisteredDeploymentUnitProcessor(priority, processor, subsystemName))) {
            throw ServerLogger.ROOT_LOGGER.duplicateDeploymentUnitProcessor(priority, processor.getClass());
        }
        registeredDeploymentUnitProcessors.add(registeredDeploymentUnitProcessor);
    }

    private DeployerChainAddHandler() {
        EnumMap map = new EnumMap(Phase.class);
        for (Phase phase : Phase.values()) {
            map.put(phase, new ConcurrentSkipListSet());
        }
        this.deployerMap = map;
    }

    public void clearDeployerMap() {
        for (Set<RegisteredDeploymentUnitProcessor> set : this.deployerMap.values()) {
            set.clear();
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.addStep((OperationStepHandler)new FinalRuntimeStepHandler(), OperationContext.Stage.RUNTIME);
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    static {
        OPERATION.get("operation").set(NAME);
        OPERATION.get("address").setEmptyList();
    }

    private class FinalRuntimeStepHandler
    implements OperationStepHandler {
        private FinalRuntimeStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            EnumMap<Phase, List<RegisteredDeploymentUnitProcessor>> finalDeployers = new EnumMap<Phase, List<RegisteredDeploymentUnitProcessor>>(Phase.class);
            ArrayList<RegisteredDeploymentUnitProcessor> processorList = new ArrayList<RegisteredDeploymentUnitProcessor>(256);
            for (Phase phase : Phase.values()) {
                processorList.clear();
                Set processorSet = (Set)DeployerChainAddHandler.this.deployerMap.get((Object)phase);
                for (RegisteredDeploymentUnitProcessor processor : processorSet) {
                    processorList.add(processor);
                }
                finalDeployers.put(phase, new ArrayList(processorList));
            }
            DeployerChainsService.addService(context.getServiceTarget(), finalDeployers);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    context.removeService(Services.JBOSS_DEPLOYMENT_CHAINS);
                }
            });
        }
    }
}

